/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.ContentSource;
import com.azure.resourcemanager.automation.models.DscConfigurationParameter;
import com.azure.resourcemanager.automation.models.DscConfigurationProvisioningState;
import com.azure.resourcemanager.automation.models.DscConfigurationState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class DscConfigurationProperties
implements JsonSerializable<DscConfigurationProperties> {
    private DscConfigurationProvisioningState provisioningState;
    private Integer jobCount;
    private Map<String, DscConfigurationParameter> parameters;
    private ContentSource source;
    private DscConfigurationState state;
    private Boolean logVerbose;
    private OffsetDateTime creationTime;
    private OffsetDateTime lastModifiedTime;
    private Integer nodeConfigurationCount;
    private String description;

    public DscConfigurationProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DscConfigurationProperties withProvisioningState(DscConfigurationProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public Integer jobCount() {
        return this.jobCount;
    }

    public DscConfigurationProperties withJobCount(Integer jobCount) {
        this.jobCount = jobCount;
        return this;
    }

    public Map<String, DscConfigurationParameter> parameters() {
        return this.parameters;
    }

    public DscConfigurationProperties withParameters(Map<String, DscConfigurationParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public ContentSource source() {
        return this.source;
    }

    public DscConfigurationProperties withSource(ContentSource source) {
        this.source = source;
        return this;
    }

    public DscConfigurationState state() {
        return this.state;
    }

    public DscConfigurationProperties withState(DscConfigurationState state) {
        this.state = state;
        return this;
    }

    public Boolean logVerbose() {
        return this.logVerbose;
    }

    public DscConfigurationProperties withLogVerbose(Boolean logVerbose) {
        this.logVerbose = logVerbose;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public DscConfigurationProperties withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public DscConfigurationProperties withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public Integer nodeConfigurationCount() {
        return this.nodeConfigurationCount;
    }

    public DscConfigurationProperties withNodeConfigurationCount(Integer nodeConfigurationCount) {
        this.nodeConfigurationCount = nodeConfigurationCount;
        return this;
    }

    public String description() {
        return this.description;
    }

    public DscConfigurationProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.source() != null) {
            this.source().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeNumberField("jobCount", (Number)this.jobCount);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeBooleanField("logVerbose", this.logVerbose);
        jsonWriter.writeStringField("creationTime", this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        jsonWriter.writeStringField("lastModifiedTime", this.lastModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        jsonWriter.writeNumberField("nodeConfigurationCount", (Number)this.nodeConfigurationCount);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static DscConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DscConfigurationProperties)jsonReader.readObject(reader -> {
            DscConfigurationProperties deserializedDscConfigurationProperties = new DscConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedDscConfigurationProperties.provisioningState = DscConfigurationProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("jobCount".equals(fieldName)) {
                    deserializedDscConfigurationProperties.jobCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedDscConfigurationProperties.parameters = parameters = reader.readMap(reader1 -> DscConfigurationParameter.fromJson(reader1));
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedDscConfigurationProperties.source = ContentSource.fromJson(reader);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedDscConfigurationProperties.state = DscConfigurationState.fromString(reader.getString());
                    continue;
                }
                if ("logVerbose".equals(fieldName)) {
                    deserializedDscConfigurationProperties.logVerbose = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedDscConfigurationProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedDscConfigurationProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("nodeConfigurationCount".equals(fieldName)) {
                    deserializedDscConfigurationProperties.nodeConfigurationCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDscConfigurationProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscConfigurationProperties;
        });
    }
}

