/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.ContentSource;
import com.azure.resourcemanager.automation.models.DscConfigurationAssociationProperty;
import java.io.IOException;

public final class DscNodeConfigurationCreateOrUpdateParametersProperties
implements JsonSerializable<DscNodeConfigurationCreateOrUpdateParametersProperties> {
    private ContentSource source;
    private DscConfigurationAssociationProperty configuration;
    private Boolean incrementNodeConfigurationBuild;
    private static final ClientLogger LOGGER = new ClientLogger(DscNodeConfigurationCreateOrUpdateParametersProperties.class);

    public ContentSource source() {
        return this.source;
    }

    public DscNodeConfigurationCreateOrUpdateParametersProperties withSource(ContentSource source) {
        this.source = source;
        return this;
    }

    public DscConfigurationAssociationProperty configuration() {
        return this.configuration;
    }

    public DscNodeConfigurationCreateOrUpdateParametersProperties withConfiguration(DscConfigurationAssociationProperty configuration) {
        this.configuration = configuration;
        return this;
    }

    public Boolean incrementNodeConfigurationBuild() {
        return this.incrementNodeConfigurationBuild;
    }

    public DscNodeConfigurationCreateOrUpdateParametersProperties withIncrementNodeConfigurationBuild(Boolean incrementNodeConfigurationBuild) {
        this.incrementNodeConfigurationBuild = incrementNodeConfigurationBuild;
        return this;
    }

    public void validate() {
        if (this.source() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property source in model DscNodeConfigurationCreateOrUpdateParametersProperties"));
        }
        this.source().validate();
        if (this.configuration() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property configuration in model DscNodeConfigurationCreateOrUpdateParametersProperties"));
        }
        this.configuration().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        jsonWriter.writeJsonField("configuration", (JsonSerializable)this.configuration);
        jsonWriter.writeBooleanField("incrementNodeConfigurationBuild", this.incrementNodeConfigurationBuild);
        return jsonWriter.writeEndObject();
    }

    public static DscNodeConfigurationCreateOrUpdateParametersProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DscNodeConfigurationCreateOrUpdateParametersProperties)jsonReader.readObject(reader -> {
            DscNodeConfigurationCreateOrUpdateParametersProperties deserializedDscNodeConfigurationCreateOrUpdateParametersProperties = new DscNodeConfigurationCreateOrUpdateParametersProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("source".equals(fieldName)) {
                    deserializedDscNodeConfigurationCreateOrUpdateParametersProperties.source = ContentSource.fromJson(reader);
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    deserializedDscNodeConfigurationCreateOrUpdateParametersProperties.configuration = DscConfigurationAssociationProperty.fromJson(reader);
                    continue;
                }
                if ("incrementNodeConfigurationBuild".equals(fieldName)) {
                    deserializedDscNodeConfigurationCreateOrUpdateParametersProperties.incrementNodeConfigurationBuild = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscNodeConfigurationCreateOrUpdateParametersProperties;
        });
    }
}

