/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.DscNodeConfigurationProperties;
import com.azure.resourcemanager.automation.models.DscConfigurationAssociationProperty;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class DscNodeConfigurationInner
extends ProxyResource {
    private DscNodeConfigurationProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private DscNodeConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public DscNodeConfigurationInner withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscNodeConfigurationProperties();
        }
        this.innerProperties().withLastModifiedTime(lastModifiedTime);
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public DscNodeConfigurationInner withCreationTime(OffsetDateTime creationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscNodeConfigurationProperties();
        }
        this.innerProperties().withCreationTime(creationTime);
        return this;
    }

    public DscConfigurationAssociationProperty configuration() {
        return this.innerProperties() == null ? null : this.innerProperties().configuration();
    }

    public DscNodeConfigurationInner withConfiguration(DscConfigurationAssociationProperty configuration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscNodeConfigurationProperties();
        }
        this.innerProperties().withConfiguration(configuration);
        return this;
    }

    public String source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    public DscNodeConfigurationInner withSource(String source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscNodeConfigurationProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    public Long nodeCount() {
        return this.innerProperties() == null ? null : this.innerProperties().nodeCount();
    }

    public DscNodeConfigurationInner withNodeCount(Long nodeCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscNodeConfigurationProperties();
        }
        this.innerProperties().withNodeCount(nodeCount);
        return this;
    }

    public Boolean incrementNodeConfigurationBuild() {
        return this.innerProperties() == null ? null : this.innerProperties().incrementNodeConfigurationBuild();
    }

    public DscNodeConfigurationInner withIncrementNodeConfigurationBuild(Boolean incrementNodeConfigurationBuild) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscNodeConfigurationProperties();
        }
        this.innerProperties().withIncrementNodeConfigurationBuild(incrementNodeConfigurationBuild);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DscNodeConfigurationInner fromJson(JsonReader jsonReader) throws IOException {
        return (DscNodeConfigurationInner)((Object)jsonReader.readObject(reader -> {
            DscNodeConfigurationInner deserializedDscNodeConfigurationInner = new DscNodeConfigurationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDscNodeConfigurationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDscNodeConfigurationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDscNodeConfigurationInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDscNodeConfigurationInner.innerProperties = DscNodeConfigurationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscNodeConfigurationInner;
        }));
    }
}

