/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.DscConfigurationAssociationProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class DscNodeConfigurationProperties
implements JsonSerializable<DscNodeConfigurationProperties> {
    private OffsetDateTime lastModifiedTime;
    private OffsetDateTime creationTime;
    private DscConfigurationAssociationProperty configuration;
    private String source;
    private Long nodeCount;
    private Boolean incrementNodeConfigurationBuild;

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public DscNodeConfigurationProperties withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public DscNodeConfigurationProperties withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public DscConfigurationAssociationProperty configuration() {
        return this.configuration;
    }

    public DscNodeConfigurationProperties withConfiguration(DscConfigurationAssociationProperty configuration) {
        this.configuration = configuration;
        return this;
    }

    public String source() {
        return this.source;
    }

    public DscNodeConfigurationProperties withSource(String source) {
        this.source = source;
        return this;
    }

    public Long nodeCount() {
        return this.nodeCount;
    }

    public DscNodeConfigurationProperties withNodeCount(Long nodeCount) {
        this.nodeCount = nodeCount;
        return this;
    }

    public Boolean incrementNodeConfigurationBuild() {
        return this.incrementNodeConfigurationBuild;
    }

    public DscNodeConfigurationProperties withIncrementNodeConfigurationBuild(Boolean incrementNodeConfigurationBuild) {
        this.incrementNodeConfigurationBuild = incrementNodeConfigurationBuild;
        return this;
    }

    public void validate() {
        if (this.configuration() != null) {
            this.configuration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lastModifiedTime", this.lastModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        jsonWriter.writeStringField("creationTime", this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        jsonWriter.writeJsonField("configuration", (JsonSerializable)this.configuration);
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeNumberField("nodeCount", (Number)this.nodeCount);
        jsonWriter.writeBooleanField("incrementNodeConfigurationBuild", this.incrementNodeConfigurationBuild);
        return jsonWriter.writeEndObject();
    }

    public static DscNodeConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DscNodeConfigurationProperties)jsonReader.readObject(reader -> {
            DscNodeConfigurationProperties deserializedDscNodeConfigurationProperties = new DscNodeConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedDscNodeConfigurationProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedDscNodeConfigurationProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    deserializedDscNodeConfigurationProperties.configuration = DscConfigurationAssociationProperty.fromJson(reader);
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedDscNodeConfigurationProperties.source = reader.getString();
                    continue;
                }
                if ("nodeCount".equals(fieldName)) {
                    deserializedDscNodeConfigurationProperties.nodeCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("incrementNodeConfigurationBuild".equals(fieldName)) {
                    deserializedDscNodeConfigurationProperties.incrementNodeConfigurationBuild = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscNodeConfigurationProperties;
        });
    }
}

