/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.DscNodeProperties;
import com.azure.resourcemanager.automation.models.DscNodeExtensionHandlerAssociationProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class DscNodeInner
extends ProxyResource {
    private DscNodeProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private DscNodeProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public OffsetDateTime lastSeen() {
        return this.innerProperties() == null ? null : this.innerProperties().lastSeen();
    }

    public DscNodeInner withLastSeen(OffsetDateTime lastSeen) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscNodeProperties();
        }
        this.innerProperties().withLastSeen(lastSeen);
        return this;
    }

    public OffsetDateTime registrationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().registrationTime();
    }

    public DscNodeInner withRegistrationTime(OffsetDateTime registrationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscNodeProperties();
        }
        this.innerProperties().withRegistrationTime(registrationTime);
        return this;
    }

    public String ip() {
        return this.innerProperties() == null ? null : this.innerProperties().ip();
    }

    public DscNodeInner withIp(String ip) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscNodeProperties();
        }
        this.innerProperties().withIp(ip);
        return this;
    }

    public String accountId() {
        return this.innerProperties() == null ? null : this.innerProperties().accountId();
    }

    public DscNodeInner withAccountId(String accountId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscNodeProperties();
        }
        this.innerProperties().withAccountId(accountId);
        return this;
    }

    public String status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public DscNodeInner withStatus(String status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscNodeProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public String nodeId() {
        return this.innerProperties() == null ? null : this.innerProperties().nodeId();
    }

    public DscNodeInner withNodeId(String nodeId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscNodeProperties();
        }
        this.innerProperties().withNodeId(nodeId);
        return this;
    }

    public String etag() {
        return this.innerProperties() == null ? null : this.innerProperties().etag();
    }

    public DscNodeInner withEtag(String etag) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscNodeProperties();
        }
        this.innerProperties().withEtag(etag);
        return this;
    }

    public Integer totalCount() {
        return this.innerProperties() == null ? null : this.innerProperties().totalCount();
    }

    public DscNodeInner withTotalCount(Integer totalCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscNodeProperties();
        }
        this.innerProperties().withTotalCount(totalCount);
        return this;
    }

    public List<DscNodeExtensionHandlerAssociationProperty> extensionHandler() {
        return this.innerProperties() == null ? null : this.innerProperties().extensionHandler();
    }

    public DscNodeInner withExtensionHandler(List<DscNodeExtensionHandlerAssociationProperty> extensionHandler) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscNodeProperties();
        }
        this.innerProperties().withExtensionHandler(extensionHandler);
        return this;
    }

    public String namePropertiesName() {
        return this.innerProperties() == null ? null : this.innerProperties().name();
    }

    public DscNodeInner withNamePropertiesName(String name) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscNodeProperties();
        }
        this.innerProperties().withName(name);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DscNodeInner fromJson(JsonReader jsonReader) throws IOException {
        return (DscNodeInner)((Object)jsonReader.readObject(reader -> {
            DscNodeInner deserializedDscNodeInner = new DscNodeInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDscNodeInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDscNodeInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDscNodeInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDscNodeInner.innerProperties = DscNodeProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscNodeInner;
        }));
    }
}

