/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.DscNodeConfigurationAssociationProperty;
import com.azure.resourcemanager.automation.models.DscNodeExtensionHandlerAssociationProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class DscNodeProperties
implements JsonSerializable<DscNodeProperties> {
    private OffsetDateTime lastSeen;
    private OffsetDateTime registrationTime;
    private String ip;
    private String accountId;
    private DscNodeConfigurationAssociationProperty innerNodeConfiguration;
    private String status;
    private String nodeId;
    private String etag;
    private Integer totalCount;
    private List<DscNodeExtensionHandlerAssociationProperty> extensionHandler;

    public OffsetDateTime lastSeen() {
        return this.lastSeen;
    }

    public DscNodeProperties withLastSeen(OffsetDateTime lastSeen) {
        this.lastSeen = lastSeen;
        return this;
    }

    public OffsetDateTime registrationTime() {
        return this.registrationTime;
    }

    public DscNodeProperties withRegistrationTime(OffsetDateTime registrationTime) {
        this.registrationTime = registrationTime;
        return this;
    }

    public String ip() {
        return this.ip;
    }

    public DscNodeProperties withIp(String ip) {
        this.ip = ip;
        return this;
    }

    public String accountId() {
        return this.accountId;
    }

    public DscNodeProperties withAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    private DscNodeConfigurationAssociationProperty innerNodeConfiguration() {
        return this.innerNodeConfiguration;
    }

    public String status() {
        return this.status;
    }

    public DscNodeProperties withStatus(String status) {
        this.status = status;
        return this;
    }

    public String nodeId() {
        return this.nodeId;
    }

    public DscNodeProperties withNodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public DscNodeProperties withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public Integer totalCount() {
        return this.totalCount;
    }

    public DscNodeProperties withTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    public List<DscNodeExtensionHandlerAssociationProperty> extensionHandler() {
        return this.extensionHandler;
    }

    public DscNodeProperties withExtensionHandler(List<DscNodeExtensionHandlerAssociationProperty> extensionHandler) {
        this.extensionHandler = extensionHandler;
        return this;
    }

    public String name() {
        return this.innerNodeConfiguration() == null ? null : this.innerNodeConfiguration().name();
    }

    public DscNodeProperties withName(String name) {
        if (this.innerNodeConfiguration() == null) {
            this.innerNodeConfiguration = new DscNodeConfigurationAssociationProperty();
        }
        this.innerNodeConfiguration().withName(name);
        return this;
    }

    public void validate() {
        if (this.innerNodeConfiguration() != null) {
            this.innerNodeConfiguration().validate();
        }
        if (this.extensionHandler() != null) {
            this.extensionHandler().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lastSeen", this.lastSeen == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastSeen));
        jsonWriter.writeStringField("registrationTime", this.registrationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.registrationTime));
        jsonWriter.writeStringField("ip", this.ip);
        jsonWriter.writeStringField("accountId", this.accountId);
        jsonWriter.writeJsonField("nodeConfiguration", (JsonSerializable)this.innerNodeConfiguration);
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("nodeId", this.nodeId);
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeNumberField("totalCount", (Number)this.totalCount);
        jsonWriter.writeArrayField("extensionHandler", this.extensionHandler, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DscNodeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DscNodeProperties)jsonReader.readObject(reader -> {
            DscNodeProperties deserializedDscNodeProperties = new DscNodeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lastSeen".equals(fieldName)) {
                    deserializedDscNodeProperties.lastSeen = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("registrationTime".equals(fieldName)) {
                    deserializedDscNodeProperties.registrationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("ip".equals(fieldName)) {
                    deserializedDscNodeProperties.ip = reader.getString();
                    continue;
                }
                if ("accountId".equals(fieldName)) {
                    deserializedDscNodeProperties.accountId = reader.getString();
                    continue;
                }
                if ("nodeConfiguration".equals(fieldName)) {
                    deserializedDscNodeProperties.innerNodeConfiguration = DscNodeConfigurationAssociationProperty.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedDscNodeProperties.status = reader.getString();
                    continue;
                }
                if ("nodeId".equals(fieldName)) {
                    deserializedDscNodeProperties.nodeId = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedDscNodeProperties.etag = reader.getString();
                    continue;
                }
                if ("totalCount".equals(fieldName)) {
                    deserializedDscNodeProperties.totalCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("extensionHandler".equals(fieldName)) {
                    List extensionHandler;
                    deserializedDscNodeProperties.extensionHandler = extensionHandler = reader.readArray(reader1 -> DscNodeExtensionHandlerAssociationProperty.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscNodeProperties;
        });
    }
}

