/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.DscMetaConfiguration;
import com.azure.resourcemanager.automation.models.DscReportError;
import com.azure.resourcemanager.automation.models.DscReportResource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class DscNodeReportInner
implements JsonSerializable<DscNodeReportInner> {
    private OffsetDateTime endTime;
    private OffsetDateTime lastModifiedTime;
    private OffsetDateTime startTime;
    private String type;
    private String reportId;
    private String status;
    private String refreshMode;
    private String rebootRequested;
    private String reportFormatVersion;
    private String configurationVersion;
    private String id;
    private List<DscReportError> errors;
    private List<DscReportResource> resources;
    private DscMetaConfiguration metaConfiguration;
    private String hostname;
    private List<String> iPV4Addresses;
    private List<String> iPV6Addresses;
    private Integer numberOfResources;
    private String rawErrors;

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public DscNodeReportInner withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public DscNodeReportInner withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public DscNodeReportInner withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public String type() {
        return this.type;
    }

    public DscNodeReportInner withType(String type) {
        this.type = type;
        return this;
    }

    public String reportId() {
        return this.reportId;
    }

    public DscNodeReportInner withReportId(String reportId) {
        this.reportId = reportId;
        return this;
    }

    public String status() {
        return this.status;
    }

    public DscNodeReportInner withStatus(String status) {
        this.status = status;
        return this;
    }

    public String refreshMode() {
        return this.refreshMode;
    }

    public DscNodeReportInner withRefreshMode(String refreshMode) {
        this.refreshMode = refreshMode;
        return this;
    }

    public String rebootRequested() {
        return this.rebootRequested;
    }

    public DscNodeReportInner withRebootRequested(String rebootRequested) {
        this.rebootRequested = rebootRequested;
        return this;
    }

    public String reportFormatVersion() {
        return this.reportFormatVersion;
    }

    public DscNodeReportInner withReportFormatVersion(String reportFormatVersion) {
        this.reportFormatVersion = reportFormatVersion;
        return this;
    }

    public String configurationVersion() {
        return this.configurationVersion;
    }

    public DscNodeReportInner withConfigurationVersion(String configurationVersion) {
        this.configurationVersion = configurationVersion;
        return this;
    }

    public String id() {
        return this.id;
    }

    public DscNodeReportInner withId(String id) {
        this.id = id;
        return this;
    }

    public List<DscReportError> errors() {
        return this.errors;
    }

    public DscNodeReportInner withErrors(List<DscReportError> errors) {
        this.errors = errors;
        return this;
    }

    public List<DscReportResource> resources() {
        return this.resources;
    }

    public DscNodeReportInner withResources(List<DscReportResource> resources) {
        this.resources = resources;
        return this;
    }

    public DscMetaConfiguration metaConfiguration() {
        return this.metaConfiguration;
    }

    public DscNodeReportInner withMetaConfiguration(DscMetaConfiguration metaConfiguration) {
        this.metaConfiguration = metaConfiguration;
        return this;
    }

    public String hostname() {
        return this.hostname;
    }

    public DscNodeReportInner withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public List<String> iPV4Addresses() {
        return this.iPV4Addresses;
    }

    public DscNodeReportInner withIPV4Addresses(List<String> iPV4Addresses) {
        this.iPV4Addresses = iPV4Addresses;
        return this;
    }

    public List<String> iPV6Addresses() {
        return this.iPV6Addresses;
    }

    public DscNodeReportInner withIPV6Addresses(List<String> iPV6Addresses) {
        this.iPV6Addresses = iPV6Addresses;
        return this;
    }

    public Integer numberOfResources() {
        return this.numberOfResources;
    }

    public DscNodeReportInner withNumberOfResources(Integer numberOfResources) {
        this.numberOfResources = numberOfResources;
        return this;
    }

    public String rawErrors() {
        return this.rawErrors;
    }

    public DscNodeReportInner withRawErrors(String rawErrors) {
        this.rawErrors = rawErrors;
        return this;
    }

    public void validate() {
        if (this.errors() != null) {
            this.errors().forEach(e -> e.validate());
        }
        if (this.resources() != null) {
            this.resources().forEach(e -> e.validate());
        }
        if (this.metaConfiguration() != null) {
            this.metaConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("lastModifiedTime", this.lastModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("reportId", this.reportId);
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("refreshMode", this.refreshMode);
        jsonWriter.writeStringField("rebootRequested", this.rebootRequested);
        jsonWriter.writeStringField("reportFormatVersion", this.reportFormatVersion);
        jsonWriter.writeStringField("configurationVersion", this.configurationVersion);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("resources", this.resources, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("metaConfiguration", (JsonSerializable)this.metaConfiguration);
        jsonWriter.writeStringField("hostName", this.hostname);
        jsonWriter.writeArrayField("iPV4Addresses", this.iPV4Addresses, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("iPV6Addresses", this.iPV6Addresses, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("numberOfResources", (Number)this.numberOfResources);
        jsonWriter.writeStringField("rawErrors", this.rawErrors);
        return jsonWriter.writeEndObject();
    }

    public static DscNodeReportInner fromJson(JsonReader jsonReader) throws IOException {
        return (DscNodeReportInner)jsonReader.readObject(reader -> {
            DscNodeReportInner deserializedDscNodeReportInner = new DscNodeReportInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endTime".equals(fieldName)) {
                    deserializedDscNodeReportInner.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedDscNodeReportInner.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedDscNodeReportInner.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDscNodeReportInner.type = reader.getString();
                    continue;
                }
                if ("reportId".equals(fieldName)) {
                    deserializedDscNodeReportInner.reportId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedDscNodeReportInner.status = reader.getString();
                    continue;
                }
                if ("refreshMode".equals(fieldName)) {
                    deserializedDscNodeReportInner.refreshMode = reader.getString();
                    continue;
                }
                if ("rebootRequested".equals(fieldName)) {
                    deserializedDscNodeReportInner.rebootRequested = reader.getString();
                    continue;
                }
                if ("reportFormatVersion".equals(fieldName)) {
                    deserializedDscNodeReportInner.reportFormatVersion = reader.getString();
                    continue;
                }
                if ("configurationVersion".equals(fieldName)) {
                    deserializedDscNodeReportInner.configurationVersion = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedDscNodeReportInner.id = reader.getString();
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedDscNodeReportInner.errors = errors = reader.readArray(reader1 -> DscReportError.fromJson(reader1));
                    continue;
                }
                if ("resources".equals(fieldName)) {
                    List resources;
                    deserializedDscNodeReportInner.resources = resources = reader.readArray(reader1 -> DscReportResource.fromJson(reader1));
                    continue;
                }
                if ("metaConfiguration".equals(fieldName)) {
                    deserializedDscNodeReportInner.metaConfiguration = DscMetaConfiguration.fromJson(reader);
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedDscNodeReportInner.hostname = reader.getString();
                    continue;
                }
                if ("iPV4Addresses".equals(fieldName)) {
                    List iPV4Addresses;
                    deserializedDscNodeReportInner.iPV4Addresses = iPV4Addresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("iPV6Addresses".equals(fieldName)) {
                    List iPV6Addresses;
                    deserializedDscNodeReportInner.iPV6Addresses = iPV6Addresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("numberOfResources".equals(fieldName)) {
                    deserializedDscNodeReportInner.numberOfResources = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("rawErrors".equals(fieldName)) {
                    deserializedDscNodeReportInner.rawErrors = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscNodeReportInner;
        });
    }
}

