/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.GroupTypeEnum;
import com.azure.resourcemanager.automation.models.RunAsCredentialAssociationProperty;
import java.io.IOException;

public final class HybridRunbookWorkerGroupProperties
implements JsonSerializable<HybridRunbookWorkerGroupProperties> {
    private GroupTypeEnum groupType;
    private RunAsCredentialAssociationProperty credential;

    public GroupTypeEnum groupType() {
        return this.groupType;
    }

    public HybridRunbookWorkerGroupProperties withGroupType(GroupTypeEnum groupType) {
        this.groupType = groupType;
        return this;
    }

    public RunAsCredentialAssociationProperty credential() {
        return this.credential;
    }

    public HybridRunbookWorkerGroupProperties withCredential(RunAsCredentialAssociationProperty credential) {
        this.credential = credential;
        return this;
    }

    public void validate() {
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("groupType", this.groupType == null ? null : this.groupType.toString());
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static HybridRunbookWorkerGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HybridRunbookWorkerGroupProperties)jsonReader.readObject(reader -> {
            HybridRunbookWorkerGroupProperties deserializedHybridRunbookWorkerGroupProperties = new HybridRunbookWorkerGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("groupType".equals(fieldName)) {
                    deserializedHybridRunbookWorkerGroupProperties.groupType = GroupTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedHybridRunbookWorkerGroupProperties.credential = RunAsCredentialAssociationProperty.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHybridRunbookWorkerGroupProperties;
        });
    }
}

