/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.HybridRunbookWorkerProperties;
import com.azure.resourcemanager.automation.models.WorkerType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class HybridRunbookWorkerInner
extends ProxyResource {
    private HybridRunbookWorkerProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private HybridRunbookWorkerProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String ip() {
        return this.innerProperties() == null ? null : this.innerProperties().ip();
    }

    public HybridRunbookWorkerInner withIp(String ip) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HybridRunbookWorkerProperties();
        }
        this.innerProperties().withIp(ip);
        return this;
    }

    public OffsetDateTime registeredDateTime() {
        return this.innerProperties() == null ? null : this.innerProperties().registeredDateTime();
    }

    public HybridRunbookWorkerInner withRegisteredDateTime(OffsetDateTime registeredDateTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HybridRunbookWorkerProperties();
        }
        this.innerProperties().withRegisteredDateTime(registeredDateTime);
        return this;
    }

    public OffsetDateTime lastSeenDateTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastSeenDateTime();
    }

    public HybridRunbookWorkerInner withLastSeenDateTime(OffsetDateTime lastSeenDateTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HybridRunbookWorkerProperties();
        }
        this.innerProperties().withLastSeenDateTime(lastSeenDateTime);
        return this;
    }

    public String vmResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().vmResourceId();
    }

    public HybridRunbookWorkerInner withVmResourceId(String vmResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HybridRunbookWorkerProperties();
        }
        this.innerProperties().withVmResourceId(vmResourceId);
        return this;
    }

    public WorkerType workerType() {
        return this.innerProperties() == null ? null : this.innerProperties().workerType();
    }

    public HybridRunbookWorkerInner withWorkerType(WorkerType workerType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HybridRunbookWorkerProperties();
        }
        this.innerProperties().withWorkerType(workerType);
        return this;
    }

    public String workerName() {
        return this.innerProperties() == null ? null : this.innerProperties().workerName();
    }

    public HybridRunbookWorkerInner withWorkerName(String workerName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HybridRunbookWorkerProperties();
        }
        this.innerProperties().withWorkerName(workerName);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static HybridRunbookWorkerInner fromJson(JsonReader jsonReader) throws IOException {
        return (HybridRunbookWorkerInner)((Object)jsonReader.readObject(reader -> {
            HybridRunbookWorkerInner deserializedHybridRunbookWorkerInner = new HybridRunbookWorkerInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedHybridRunbookWorkerInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedHybridRunbookWorkerInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHybridRunbookWorkerInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedHybridRunbookWorkerInner.innerProperties = HybridRunbookWorkerProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedHybridRunbookWorkerInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHybridRunbookWorkerInner;
        }));
    }
}

