/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.WorkerType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class HybridRunbookWorkerProperties
implements JsonSerializable<HybridRunbookWorkerProperties> {
    private String ip;
    private OffsetDateTime registeredDateTime;
    private OffsetDateTime lastSeenDateTime;
    private String vmResourceId;
    private WorkerType workerType;
    private String workerName;

    public String ip() {
        return this.ip;
    }

    public HybridRunbookWorkerProperties withIp(String ip) {
        this.ip = ip;
        return this;
    }

    public OffsetDateTime registeredDateTime() {
        return this.registeredDateTime;
    }

    public HybridRunbookWorkerProperties withRegisteredDateTime(OffsetDateTime registeredDateTime) {
        this.registeredDateTime = registeredDateTime;
        return this;
    }

    public OffsetDateTime lastSeenDateTime() {
        return this.lastSeenDateTime;
    }

    public HybridRunbookWorkerProperties withLastSeenDateTime(OffsetDateTime lastSeenDateTime) {
        this.lastSeenDateTime = lastSeenDateTime;
        return this;
    }

    public String vmResourceId() {
        return this.vmResourceId;
    }

    public HybridRunbookWorkerProperties withVmResourceId(String vmResourceId) {
        this.vmResourceId = vmResourceId;
        return this;
    }

    public WorkerType workerType() {
        return this.workerType;
    }

    public HybridRunbookWorkerProperties withWorkerType(WorkerType workerType) {
        this.workerType = workerType;
        return this;
    }

    public String workerName() {
        return this.workerName;
    }

    public HybridRunbookWorkerProperties withWorkerName(String workerName) {
        this.workerName = workerName;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ip", this.ip);
        jsonWriter.writeStringField("registeredDateTime", this.registeredDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.registeredDateTime));
        jsonWriter.writeStringField("lastSeenDateTime", this.lastSeenDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastSeenDateTime));
        jsonWriter.writeStringField("vmResourceId", this.vmResourceId);
        jsonWriter.writeStringField("workerType", this.workerType == null ? null : this.workerType.toString());
        jsonWriter.writeStringField("workerName", this.workerName);
        return jsonWriter.writeEndObject();
    }

    public static HybridRunbookWorkerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HybridRunbookWorkerProperties)jsonReader.readObject(reader -> {
            HybridRunbookWorkerProperties deserializedHybridRunbookWorkerProperties = new HybridRunbookWorkerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ip".equals(fieldName)) {
                    deserializedHybridRunbookWorkerProperties.ip = reader.getString();
                    continue;
                }
                if ("registeredDateTime".equals(fieldName)) {
                    deserializedHybridRunbookWorkerProperties.registeredDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastSeenDateTime".equals(fieldName)) {
                    deserializedHybridRunbookWorkerProperties.lastSeenDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("vmResourceId".equals(fieldName)) {
                    deserializedHybridRunbookWorkerProperties.vmResourceId = reader.getString();
                    continue;
                }
                if ("workerType".equals(fieldName)) {
                    deserializedHybridRunbookWorkerProperties.workerType = WorkerType.fromString(reader.getString());
                    continue;
                }
                if ("workerName".equals(fieldName)) {
                    deserializedHybridRunbookWorkerProperties.workerName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHybridRunbookWorkerProperties;
        });
    }
}

