/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.JobCollectionItemProperties;
import com.azure.resourcemanager.automation.models.JobStatus;
import com.azure.resourcemanager.automation.models.RunbookAssociationProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.UUID;

public final class JobCollectionItemInner
extends ProxyResource {
    private JobCollectionItemProperties innerProperties = new JobCollectionItemProperties();
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(JobCollectionItemInner.class);

    private JobCollectionItemProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public RunbookAssociationProperty runbook() {
        return this.innerProperties() == null ? null : this.innerProperties().runbook();
    }

    public UUID jobId() {
        return this.innerProperties() == null ? null : this.innerProperties().jobId();
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public JobStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String runOn() {
        return this.innerProperties() == null ? null : this.innerProperties().runOn();
    }

    public JobCollectionItemInner withRunOn(String runOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobCollectionItemProperties();
        }
        this.innerProperties().withRunOn(runOn);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model JobCollectionItemInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static JobCollectionItemInner fromJson(JsonReader jsonReader) throws IOException {
        return (JobCollectionItemInner)((Object)jsonReader.readObject(reader -> {
            JobCollectionItemInner deserializedJobCollectionItemInner = new JobCollectionItemInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedJobCollectionItemInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedJobCollectionItemInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedJobCollectionItemInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedJobCollectionItemInner.innerProperties = JobCollectionItemProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobCollectionItemInner;
        }));
    }
}

