/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.JobStatus;
import com.azure.resourcemanager.automation.models.RunbookAssociationProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.UUID;

public final class JobCollectionItemProperties
implements JsonSerializable<JobCollectionItemProperties> {
    private RunbookAssociationProperty runbook;
    private UUID jobId;
    private OffsetDateTime creationTime;
    private JobStatus status;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private OffsetDateTime lastModifiedTime;
    private String provisioningState;
    private String runOn;

    public RunbookAssociationProperty runbook() {
        return this.runbook;
    }

    public UUID jobId() {
        return this.jobId;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public JobStatus status() {
        return this.status;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public String runOn() {
        return this.runOn;
    }

    public JobCollectionItemProperties withRunOn(String runOn) {
        this.runOn = runOn;
        return this;
    }

    public void validate() {
        if (this.runbook() != null) {
            this.runbook().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("runOn", this.runOn);
        return jsonWriter.writeEndObject();
    }

    public static JobCollectionItemProperties fromJson(JsonReader jsonReader) throws IOException {
        return (JobCollectionItemProperties)jsonReader.readObject(reader -> {
            JobCollectionItemProperties deserializedJobCollectionItemProperties = new JobCollectionItemProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("runbook".equals(fieldName)) {
                    deserializedJobCollectionItemProperties.runbook = RunbookAssociationProperty.fromJson(reader);
                    continue;
                }
                if ("jobId".equals(fieldName)) {
                    deserializedJobCollectionItemProperties.jobId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedJobCollectionItemProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedJobCollectionItemProperties.status = JobStatus.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedJobCollectionItemProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedJobCollectionItemProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedJobCollectionItemProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedJobCollectionItemProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("runOn".equals(fieldName)) {
                    deserializedJobCollectionItemProperties.runOn = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobCollectionItemProperties;
        });
    }
}

