/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.RunbookAssociationProperty;
import java.io.IOException;
import java.util.Map;

public final class JobCreateProperties
implements JsonSerializable<JobCreateProperties> {
    private RunbookAssociationProperty runbook;
    private Map<String, String> parameters;
    private String runOn;

    public RunbookAssociationProperty runbook() {
        return this.runbook;
    }

    public JobCreateProperties withRunbook(RunbookAssociationProperty runbook) {
        this.runbook = runbook;
        return this;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public JobCreateProperties withParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public String runOn() {
        return this.runOn;
    }

    public JobCreateProperties withRunOn(String runOn) {
        this.runOn = runOn;
        return this;
    }

    public void validate() {
        if (this.runbook() != null) {
            this.runbook().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("runbook", (JsonSerializable)this.runbook);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("runOn", this.runOn);
        return jsonWriter.writeEndObject();
    }

    public static JobCreateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (JobCreateProperties)jsonReader.readObject(reader -> {
            JobCreateProperties deserializedJobCreateProperties = new JobCreateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("runbook".equals(fieldName)) {
                    deserializedJobCreateProperties.runbook = RunbookAssociationProperty.fromJson(reader);
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedJobCreateProperties.parameters = parameters = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("runOn".equals(fieldName)) {
                    deserializedJobCreateProperties.runOn = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobCreateProperties;
        });
    }
}

