/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.JobProperties;
import com.azure.resourcemanager.automation.models.JobProvisioningState;
import com.azure.resourcemanager.automation.models.JobStatus;
import com.azure.resourcemanager.automation.models.RunbookAssociationProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

public final class JobInner
extends ProxyResource {
    private JobProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private JobProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public RunbookAssociationProperty runbook() {
        return this.innerProperties() == null ? null : this.innerProperties().runbook();
    }

    public JobInner withRunbook(RunbookAssociationProperty runbook) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withRunbook(runbook);
        return this;
    }

    public String startedBy() {
        return this.innerProperties() == null ? null : this.innerProperties().startedBy();
    }

    public JobInner withStartedBy(String startedBy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withStartedBy(startedBy);
        return this;
    }

    public String runOn() {
        return this.innerProperties() == null ? null : this.innerProperties().runOn();
    }

    public JobInner withRunOn(String runOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withRunOn(runOn);
        return this;
    }

    public UUID jobId() {
        return this.innerProperties() == null ? null : this.innerProperties().jobId();
    }

    public JobInner withJobId(UUID jobId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withJobId(jobId);
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public JobInner withCreationTime(OffsetDateTime creationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withCreationTime(creationTime);
        return this;
    }

    public JobStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public JobInner withStatus(JobStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public String statusDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().statusDetails();
    }

    public JobInner withStatusDetails(String statusDetails) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withStatusDetails(statusDetails);
        return this;
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public JobInner withStartTime(OffsetDateTime startTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withStartTime(startTime);
        return this;
    }

    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    public JobInner withEndTime(OffsetDateTime endTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withEndTime(endTime);
        return this;
    }

    public String exception() {
        return this.innerProperties() == null ? null : this.innerProperties().exception();
    }

    public JobInner withException(String exception) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withException(exception);
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public JobInner withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withLastModifiedTime(lastModifiedTime);
        return this;
    }

    public OffsetDateTime lastStatusModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastStatusModifiedTime();
    }

    public JobInner withLastStatusModifiedTime(OffsetDateTime lastStatusModifiedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withLastStatusModifiedTime(lastStatusModifiedTime);
        return this;
    }

    public Map<String, String> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public JobInner withParameters(Map<String, String> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public JobProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public JobInner withProvisioningState(JobProvisioningState provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static JobInner fromJson(JsonReader jsonReader) throws IOException {
        return (JobInner)((Object)jsonReader.readObject(reader -> {
            JobInner deserializedJobInner = new JobInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedJobInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedJobInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedJobInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedJobInner.innerProperties = JobProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobInner;
        }));
    }
}

