/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.JobProvisioningState;
import com.azure.resourcemanager.automation.models.JobStatus;
import com.azure.resourcemanager.automation.models.RunbookAssociationProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class JobProperties
implements JsonSerializable<JobProperties> {
    private RunbookAssociationProperty runbook;
    private String startedBy;
    private String runOn;
    private UUID jobId;
    private OffsetDateTime creationTime;
    private JobStatus status;
    private String statusDetails;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private String exception;
    private OffsetDateTime lastModifiedTime;
    private OffsetDateTime lastStatusModifiedTime;
    private Map<String, String> parameters;
    private JobProvisioningState provisioningState;

    public RunbookAssociationProperty runbook() {
        return this.runbook;
    }

    public JobProperties withRunbook(RunbookAssociationProperty runbook) {
        this.runbook = runbook;
        return this;
    }

    public String startedBy() {
        return this.startedBy;
    }

    public JobProperties withStartedBy(String startedBy) {
        this.startedBy = startedBy;
        return this;
    }

    public String runOn() {
        return this.runOn;
    }

    public JobProperties withRunOn(String runOn) {
        this.runOn = runOn;
        return this;
    }

    public UUID jobId() {
        return this.jobId;
    }

    public JobProperties withJobId(UUID jobId) {
        this.jobId = jobId;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public JobProperties withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public JobStatus status() {
        return this.status;
    }

    public JobProperties withStatus(JobStatus status) {
        this.status = status;
        return this;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public JobProperties withStatusDetails(String statusDetails) {
        this.statusDetails = statusDetails;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public JobProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public JobProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public String exception() {
        return this.exception;
    }

    public JobProperties withException(String exception) {
        this.exception = exception;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public JobProperties withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public OffsetDateTime lastStatusModifiedTime() {
        return this.lastStatusModifiedTime;
    }

    public JobProperties withLastStatusModifiedTime(OffsetDateTime lastStatusModifiedTime) {
        this.lastStatusModifiedTime = lastStatusModifiedTime;
        return this;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public JobProperties withParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public JobProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public JobProperties withProvisioningState(JobProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public void validate() {
        if (this.runbook() != null) {
            this.runbook().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("runbook", (JsonSerializable)this.runbook);
        jsonWriter.writeStringField("startedBy", this.startedBy);
        jsonWriter.writeStringField("runOn", this.runOn);
        jsonWriter.writeStringField("jobId", Objects.toString(this.jobId, null));
        jsonWriter.writeStringField("creationTime", this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("statusDetails", this.statusDetails);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("exception", this.exception);
        jsonWriter.writeStringField("lastModifiedTime", this.lastModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        jsonWriter.writeStringField("lastStatusModifiedTime", this.lastStatusModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastStatusModifiedTime));
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        return jsonWriter.writeEndObject();
    }

    public static JobProperties fromJson(JsonReader jsonReader) throws IOException {
        return (JobProperties)jsonReader.readObject(reader -> {
            JobProperties deserializedJobProperties = new JobProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("runbook".equals(fieldName)) {
                    deserializedJobProperties.runbook = RunbookAssociationProperty.fromJson(reader);
                    continue;
                }
                if ("startedBy".equals(fieldName)) {
                    deserializedJobProperties.startedBy = reader.getString();
                    continue;
                }
                if ("runOn".equals(fieldName)) {
                    deserializedJobProperties.runOn = reader.getString();
                    continue;
                }
                if ("jobId".equals(fieldName)) {
                    deserializedJobProperties.jobId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedJobProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedJobProperties.status = JobStatus.fromString(reader.getString());
                    continue;
                }
                if ("statusDetails".equals(fieldName)) {
                    deserializedJobProperties.statusDetails = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedJobProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedJobProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("exception".equals(fieldName)) {
                    deserializedJobProperties.exception = reader.getString();
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedJobProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastStatusModifiedTime".equals(fieldName)) {
                    deserializedJobProperties.lastStatusModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedJobProperties.parameters = parameters = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedJobProperties.provisioningState = JobProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobProperties;
        });
    }
}

