/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.RunbookAssociationProperty;
import com.azure.resourcemanager.automation.models.ScheduleAssociationProperty;
import java.io.IOException;
import java.util.Map;

public final class JobScheduleCreateProperties
implements JsonSerializable<JobScheduleCreateProperties> {
    private ScheduleAssociationProperty schedule;
    private RunbookAssociationProperty runbook;
    private String runOn;
    private Map<String, String> parameters;
    private static final ClientLogger LOGGER = new ClientLogger(JobScheduleCreateProperties.class);

    public ScheduleAssociationProperty schedule() {
        return this.schedule;
    }

    public JobScheduleCreateProperties withSchedule(ScheduleAssociationProperty schedule) {
        this.schedule = schedule;
        return this;
    }

    public RunbookAssociationProperty runbook() {
        return this.runbook;
    }

    public JobScheduleCreateProperties withRunbook(RunbookAssociationProperty runbook) {
        this.runbook = runbook;
        return this;
    }

    public String runOn() {
        return this.runOn;
    }

    public JobScheduleCreateProperties withRunOn(String runOn) {
        this.runOn = runOn;
        return this;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public JobScheduleCreateProperties withParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.schedule() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property schedule in model JobScheduleCreateProperties"));
        }
        this.schedule().validate();
        if (this.runbook() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property runbook in model JobScheduleCreateProperties"));
        }
        this.runbook().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("schedule", (JsonSerializable)this.schedule);
        jsonWriter.writeJsonField("runbook", (JsonSerializable)this.runbook);
        jsonWriter.writeStringField("runOn", this.runOn);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static JobScheduleCreateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (JobScheduleCreateProperties)jsonReader.readObject(reader -> {
            JobScheduleCreateProperties deserializedJobScheduleCreateProperties = new JobScheduleCreateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schedule".equals(fieldName)) {
                    deserializedJobScheduleCreateProperties.schedule = ScheduleAssociationProperty.fromJson(reader);
                    continue;
                }
                if ("runbook".equals(fieldName)) {
                    deserializedJobScheduleCreateProperties.runbook = RunbookAssociationProperty.fromJson(reader);
                    continue;
                }
                if ("runOn".equals(fieldName)) {
                    deserializedJobScheduleCreateProperties.runOn = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedJobScheduleCreateProperties.parameters = parameters = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobScheduleCreateProperties;
        });
    }
}

