/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.JobScheduleProperties;
import com.azure.resourcemanager.automation.models.RunbookAssociationProperty;
import com.azure.resourcemanager.automation.models.ScheduleAssociationProperty;
import java.io.IOException;
import java.util.Map;

public final class JobScheduleInner
implements JsonSerializable<JobScheduleInner> {
    private String id;
    private String name;
    private String type;
    private JobScheduleProperties innerProperties;

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    private JobScheduleProperties innerProperties() {
        return this.innerProperties;
    }

    public String jobScheduleId() {
        return this.innerProperties() == null ? null : this.innerProperties().jobScheduleId();
    }

    public JobScheduleInner withJobScheduleId(String jobScheduleId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobScheduleProperties();
        }
        this.innerProperties().withJobScheduleId(jobScheduleId);
        return this;
    }

    public ScheduleAssociationProperty schedule() {
        return this.innerProperties() == null ? null : this.innerProperties().schedule();
    }

    public JobScheduleInner withSchedule(ScheduleAssociationProperty schedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobScheduleProperties();
        }
        this.innerProperties().withSchedule(schedule);
        return this;
    }

    public RunbookAssociationProperty runbook() {
        return this.innerProperties() == null ? null : this.innerProperties().runbook();
    }

    public JobScheduleInner withRunbook(RunbookAssociationProperty runbook) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobScheduleProperties();
        }
        this.innerProperties().withRunbook(runbook);
        return this;
    }

    public String runOn() {
        return this.innerProperties() == null ? null : this.innerProperties().runOn();
    }

    public JobScheduleInner withRunOn(String runOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobScheduleProperties();
        }
        this.innerProperties().withRunOn(runOn);
        return this;
    }

    public Map<String, String> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public JobScheduleInner withParameters(Map<String, String> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobScheduleProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static JobScheduleInner fromJson(JsonReader jsonReader) throws IOException {
        return (JobScheduleInner)jsonReader.readObject(reader -> {
            JobScheduleInner deserializedJobScheduleInner = new JobScheduleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedJobScheduleInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedJobScheduleInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedJobScheduleInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedJobScheduleInner.innerProperties = JobScheduleProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobScheduleInner;
        });
    }
}

