/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.RunbookAssociationProperty;
import com.azure.resourcemanager.automation.models.ScheduleAssociationProperty;
import java.io.IOException;
import java.util.Map;

public final class JobScheduleProperties
implements JsonSerializable<JobScheduleProperties> {
    private String jobScheduleId;
    private ScheduleAssociationProperty schedule;
    private RunbookAssociationProperty runbook;
    private String runOn;
    private Map<String, String> parameters;

    public String jobScheduleId() {
        return this.jobScheduleId;
    }

    public JobScheduleProperties withJobScheduleId(String jobScheduleId) {
        this.jobScheduleId = jobScheduleId;
        return this;
    }

    public ScheduleAssociationProperty schedule() {
        return this.schedule;
    }

    public JobScheduleProperties withSchedule(ScheduleAssociationProperty schedule) {
        this.schedule = schedule;
        return this;
    }

    public RunbookAssociationProperty runbook() {
        return this.runbook;
    }

    public JobScheduleProperties withRunbook(RunbookAssociationProperty runbook) {
        this.runbook = runbook;
        return this;
    }

    public String runOn() {
        return this.runOn;
    }

    public JobScheduleProperties withRunOn(String runOn) {
        this.runOn = runOn;
        return this;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public JobScheduleProperties withParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.schedule() != null) {
            this.schedule().validate();
        }
        if (this.runbook() != null) {
            this.runbook().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("jobScheduleId", this.jobScheduleId);
        jsonWriter.writeJsonField("schedule", (JsonSerializable)this.schedule);
        jsonWriter.writeJsonField("runbook", (JsonSerializable)this.runbook);
        jsonWriter.writeStringField("runOn", this.runOn);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static JobScheduleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (JobScheduleProperties)jsonReader.readObject(reader -> {
            JobScheduleProperties deserializedJobScheduleProperties = new JobScheduleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("jobScheduleId".equals(fieldName)) {
                    deserializedJobScheduleProperties.jobScheduleId = reader.getString();
                    continue;
                }
                if ("schedule".equals(fieldName)) {
                    deserializedJobScheduleProperties.schedule = ScheduleAssociationProperty.fromJson(reader);
                    continue;
                }
                if ("runbook".equals(fieldName)) {
                    deserializedJobScheduleProperties.runbook = RunbookAssociationProperty.fromJson(reader);
                    continue;
                }
                if ("runOn".equals(fieldName)) {
                    deserializedJobScheduleProperties.runOn = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedJobScheduleProperties.parameters = parameters = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobScheduleProperties;
        });
    }
}

