/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.JobStreamProperties;
import com.azure.resourcemanager.automation.models.JobStreamType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class JobStreamInner
implements JsonSerializable<JobStreamInner> {
    private String id;
    private JobStreamProperties innerProperties;

    public String id() {
        return this.id;
    }

    public JobStreamInner withId(String id) {
        this.id = id;
        return this;
    }

    private JobStreamProperties innerProperties() {
        return this.innerProperties;
    }

    public String jobStreamId() {
        return this.innerProperties() == null ? null : this.innerProperties().jobStreamId();
    }

    public JobStreamInner withJobStreamId(String jobStreamId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobStreamProperties();
        }
        this.innerProperties().withJobStreamId(jobStreamId);
        return this;
    }

    public OffsetDateTime time() {
        return this.innerProperties() == null ? null : this.innerProperties().time();
    }

    public JobStreamInner withTime(OffsetDateTime time) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobStreamProperties();
        }
        this.innerProperties().withTime(time);
        return this;
    }

    public JobStreamType streamType() {
        return this.innerProperties() == null ? null : this.innerProperties().streamType();
    }

    public JobStreamInner withStreamType(JobStreamType streamType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobStreamProperties();
        }
        this.innerProperties().withStreamType(streamType);
        return this;
    }

    public String streamText() {
        return this.innerProperties() == null ? null : this.innerProperties().streamText();
    }

    public JobStreamInner withStreamText(String streamText) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobStreamProperties();
        }
        this.innerProperties().withStreamText(streamText);
        return this;
    }

    public String summary() {
        return this.innerProperties() == null ? null : this.innerProperties().summary();
    }

    public JobStreamInner withSummary(String summary) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobStreamProperties();
        }
        this.innerProperties().withSummary(summary);
        return this;
    }

    public Map<String, Object> value() {
        return this.innerProperties() == null ? null : this.innerProperties().value();
    }

    public JobStreamInner withValue(Map<String, Object> value) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobStreamProperties();
        }
        this.innerProperties().withValue(value);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static JobStreamInner fromJson(JsonReader jsonReader) throws IOException {
        return (JobStreamInner)jsonReader.readObject(reader -> {
            JobStreamInner deserializedJobStreamInner = new JobStreamInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedJobStreamInner.id = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedJobStreamInner.innerProperties = JobStreamProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobStreamInner;
        });
    }
}

