/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.JobStreamType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class JobStreamProperties
implements JsonSerializable<JobStreamProperties> {
    private String jobStreamId;
    private OffsetDateTime time;
    private JobStreamType streamType;
    private String streamText;
    private String summary;
    private Map<String, Object> value;

    public String jobStreamId() {
        return this.jobStreamId;
    }

    public JobStreamProperties withJobStreamId(String jobStreamId) {
        this.jobStreamId = jobStreamId;
        return this;
    }

    public OffsetDateTime time() {
        return this.time;
    }

    public JobStreamProperties withTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    public JobStreamType streamType() {
        return this.streamType;
    }

    public JobStreamProperties withStreamType(JobStreamType streamType) {
        this.streamType = streamType;
        return this;
    }

    public String streamText() {
        return this.streamText;
    }

    public JobStreamProperties withStreamText(String streamText) {
        this.streamText = streamText;
        return this;
    }

    public String summary() {
        return this.summary;
    }

    public JobStreamProperties withSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public Map<String, Object> value() {
        return this.value;
    }

    public JobStreamProperties withValue(Map<String, Object> value) {
        this.value = value;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("jobStreamId", this.jobStreamId);
        jsonWriter.writeStringField("time", this.time == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.time));
        jsonWriter.writeStringField("streamType", this.streamType == null ? null : this.streamType.toString());
        jsonWriter.writeStringField("streamText", this.streamText);
        jsonWriter.writeStringField("summary", this.summary);
        jsonWriter.writeMapField("value", this.value, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static JobStreamProperties fromJson(JsonReader jsonReader) throws IOException {
        return (JobStreamProperties)jsonReader.readObject(reader -> {
            JobStreamProperties deserializedJobStreamProperties = new JobStreamProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("jobStreamId".equals(fieldName)) {
                    deserializedJobStreamProperties.jobStreamId = reader.getString();
                    continue;
                }
                if ("time".equals(fieldName)) {
                    deserializedJobStreamProperties.time = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("streamType".equals(fieldName)) {
                    deserializedJobStreamProperties.streamType = JobStreamType.fromString(reader.getString());
                    continue;
                }
                if ("streamText".equals(fieldName)) {
                    deserializedJobStreamProperties.streamText = reader.getString();
                    continue;
                }
                if ("summary".equals(fieldName)) {
                    deserializedJobStreamProperties.summary = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    Map value;
                    deserializedJobStreamProperties.value = value = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobStreamProperties;
        });
    }
}

