/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.ContentLink;
import java.io.IOException;

public final class ModuleCreateOrUpdateProperties
implements JsonSerializable<ModuleCreateOrUpdateProperties> {
    private ContentLink contentLink;
    private static final ClientLogger LOGGER = new ClientLogger(ModuleCreateOrUpdateProperties.class);

    public ContentLink contentLink() {
        return this.contentLink;
    }

    public ModuleCreateOrUpdateProperties withContentLink(ContentLink contentLink) {
        this.contentLink = contentLink;
        return this;
    }

    public void validate() {
        if (this.contentLink() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property contentLink in model ModuleCreateOrUpdateProperties"));
        }
        this.contentLink().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("contentLink", (JsonSerializable)this.contentLink);
        return jsonWriter.writeEndObject();
    }

    public static ModuleCreateOrUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ModuleCreateOrUpdateProperties)jsonReader.readObject(reader -> {
            ModuleCreateOrUpdateProperties deserializedModuleCreateOrUpdateProperties = new ModuleCreateOrUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contentLink".equals(fieldName)) {
                    deserializedModuleCreateOrUpdateProperties.contentLink = ContentLink.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedModuleCreateOrUpdateProperties;
        });
    }
}

