/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.ModuleProperties;
import com.azure.resourcemanager.automation.models.ContentLink;
import com.azure.resourcemanager.automation.models.ModuleErrorInfo;
import com.azure.resourcemanager.automation.models.ModuleProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ModuleInner
extends Resource {
    private ModuleProperties innerProperties;
    private String etag;
    private String type;
    private String name;
    private String id;

    private ModuleProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public ModuleInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ModuleInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ModuleInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Boolean isGlobal() {
        return this.innerProperties() == null ? null : this.innerProperties().isGlobal();
    }

    public ModuleInner withIsGlobal(Boolean isGlobal) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ModuleProperties();
        }
        this.innerProperties().withIsGlobal(isGlobal);
        return this;
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public ModuleInner withVersion(String version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ModuleProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    public Long sizeInBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().sizeInBytes();
    }

    public ModuleInner withSizeInBytes(Long sizeInBytes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ModuleProperties();
        }
        this.innerProperties().withSizeInBytes(sizeInBytes);
        return this;
    }

    public Integer activityCount() {
        return this.innerProperties() == null ? null : this.innerProperties().activityCount();
    }

    public ModuleInner withActivityCount(Integer activityCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ModuleProperties();
        }
        this.innerProperties().withActivityCount(activityCount);
        return this;
    }

    public ModuleProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public ModuleInner withProvisioningState(ModuleProvisioningState provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ModuleProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    public ContentLink contentLink() {
        return this.innerProperties() == null ? null : this.innerProperties().contentLink();
    }

    public ModuleInner withContentLink(ContentLink contentLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ModuleProperties();
        }
        this.innerProperties().withContentLink(contentLink);
        return this;
    }

    public ModuleErrorInfo error() {
        return this.innerProperties() == null ? null : this.innerProperties().error();
    }

    public ModuleInner withError(ModuleErrorInfo error) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ModuleProperties();
        }
        this.innerProperties().withError(error);
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public ModuleInner withCreationTime(OffsetDateTime creationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ModuleProperties();
        }
        this.innerProperties().withCreationTime(creationTime);
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public ModuleInner withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ModuleProperties();
        }
        this.innerProperties().withLastModifiedTime(lastModifiedTime);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ModuleInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ModuleProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public Boolean isComposite() {
        return this.innerProperties() == null ? null : this.innerProperties().isComposite();
    }

    public ModuleInner withIsComposite(Boolean isComposite) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ModuleProperties();
        }
        this.innerProperties().withIsComposite(isComposite);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("etag", this.etag);
        return jsonWriter.writeEndObject();
    }

    public static ModuleInner fromJson(JsonReader jsonReader) throws IOException {
        return (ModuleInner)((Object)jsonReader.readObject(reader -> {
            ModuleInner deserializedModuleInner = new ModuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedModuleInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedModuleInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedModuleInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedModuleInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedModuleInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedModuleInner.innerProperties = ModuleProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedModuleInner.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedModuleInner;
        }));
    }
}

