/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.ContentLink;
import com.azure.resourcemanager.automation.models.ModuleErrorInfo;
import com.azure.resourcemanager.automation.models.ModuleProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ModuleProperties
implements JsonSerializable<ModuleProperties> {
    private Boolean isGlobal;
    private String version;
    private Long sizeInBytes;
    private Integer activityCount;
    private ModuleProvisioningState provisioningState;
    private ContentLink contentLink;
    private ModuleErrorInfo error;
    private OffsetDateTime creationTime;
    private OffsetDateTime lastModifiedTime;
    private String description;
    private Boolean isComposite;

    public Boolean isGlobal() {
        return this.isGlobal;
    }

    public ModuleProperties withIsGlobal(Boolean isGlobal) {
        this.isGlobal = isGlobal;
        return this;
    }

    public String version() {
        return this.version;
    }

    public ModuleProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    public Long sizeInBytes() {
        return this.sizeInBytes;
    }

    public ModuleProperties withSizeInBytes(Long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
        return this;
    }

    public Integer activityCount() {
        return this.activityCount;
    }

    public ModuleProperties withActivityCount(Integer activityCount) {
        this.activityCount = activityCount;
        return this;
    }

    public ModuleProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ModuleProperties withProvisioningState(ModuleProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public ContentLink contentLink() {
        return this.contentLink;
    }

    public ModuleProperties withContentLink(ContentLink contentLink) {
        this.contentLink = contentLink;
        return this;
    }

    public ModuleErrorInfo error() {
        return this.error;
    }

    public ModuleProperties withError(ModuleErrorInfo error) {
        this.error = error;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public ModuleProperties withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public ModuleProperties withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ModuleProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Boolean isComposite() {
        return this.isComposite;
    }

    public ModuleProperties withIsComposite(Boolean isComposite) {
        this.isComposite = isComposite;
        return this;
    }

    public void validate() {
        if (this.contentLink() != null) {
            this.contentLink().validate();
        }
        if (this.error() != null) {
            this.error().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isGlobal", this.isGlobal);
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeNumberField("sizeInBytes", (Number)this.sizeInBytes);
        jsonWriter.writeNumberField("activityCount", (Number)this.activityCount);
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeJsonField("contentLink", (JsonSerializable)this.contentLink);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeStringField("creationTime", this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        jsonWriter.writeStringField("lastModifiedTime", this.lastModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeBooleanField("isComposite", this.isComposite);
        return jsonWriter.writeEndObject();
    }

    public static ModuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ModuleProperties)jsonReader.readObject(reader -> {
            ModuleProperties deserializedModuleProperties = new ModuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("isGlobal".equals(fieldName)) {
                    deserializedModuleProperties.isGlobal = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedModuleProperties.version = reader.getString();
                    continue;
                }
                if ("sizeInBytes".equals(fieldName)) {
                    deserializedModuleProperties.sizeInBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("activityCount".equals(fieldName)) {
                    deserializedModuleProperties.activityCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedModuleProperties.provisioningState = ModuleProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("contentLink".equals(fieldName)) {
                    deserializedModuleProperties.contentLink = ContentLink.fromJson(reader);
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedModuleProperties.error = ModuleErrorInfo.fromJson(reader);
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedModuleProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedModuleProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedModuleProperties.description = reader.getString();
                    continue;
                }
                if ("isComposite".equals(fieldName)) {
                    deserializedModuleProperties.isComposite = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedModuleProperties;
        });
    }
}

