/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.PrivateEndpointProperty;
import com.azure.resourcemanager.automation.models.PrivateLinkServiceConnectionStateProperty;
import java.io.IOException;
import java.util.List;

public final class PrivateEndpointConnectionProperties
implements JsonSerializable<PrivateEndpointConnectionProperties> {
    private PrivateEndpointProperty privateEndpoint;
    private List<String> groupIds;
    private PrivateLinkServiceConnectionStateProperty privateLinkServiceConnectionState;

    public PrivateEndpointProperty privateEndpoint() {
        return this.privateEndpoint;
    }

    public PrivateEndpointConnectionProperties withPrivateEndpoint(PrivateEndpointProperty privateEndpoint) {
        this.privateEndpoint = privateEndpoint;
        return this;
    }

    public List<String> groupIds() {
        return this.groupIds;
    }

    public PrivateEndpointConnectionProperties withGroupIds(List<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public PrivateLinkServiceConnectionStateProperty privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    public PrivateEndpointConnectionProperties withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionStateProperty privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    public void validate() {
        if (this.privateEndpoint() != null) {
            this.privateEndpoint().validate();
        }
        if (this.privateLinkServiceConnectionState() != null) {
            this.privateLinkServiceConnectionState().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("privateEndpoint", (JsonSerializable)this.privateEndpoint);
        jsonWriter.writeArrayField("groupIds", this.groupIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("privateLinkServiceConnectionState", (JsonSerializable)this.privateLinkServiceConnectionState);
        return jsonWriter.writeEndObject();
    }

    public static PrivateEndpointConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateEndpointConnectionProperties)jsonReader.readObject(reader -> {
            PrivateEndpointConnectionProperties deserializedPrivateEndpointConnectionProperties = new PrivateEndpointConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateEndpoint".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionProperties.privateEndpoint = PrivateEndpointProperty.fromJson(reader);
                    continue;
                }
                if ("groupIds".equals(fieldName)) {
                    List groupIds;
                    deserializedPrivateEndpointConnectionProperties.groupIds = groupIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("privateLinkServiceConnectionState".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionProperties.privateLinkServiceConnectionState = PrivateLinkServiceConnectionStateProperty.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateEndpointConnectionProperties;
        });
    }
}

