/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.RunbookDraftInner;
import com.azure.resourcemanager.automation.models.ContentLink;
import com.azure.resourcemanager.automation.models.RunbookTypeEnum;
import java.io.IOException;

public final class RunbookCreateOrUpdatePropertiesInner
implements JsonSerializable<RunbookCreateOrUpdatePropertiesInner> {
    private Boolean logVerbose;
    private Boolean logProgress;
    private RunbookTypeEnum runbookType;
    private RunbookDraftInner draft;
    private ContentLink publishContentLink;
    private String description;
    private Integer logActivityTrace;
    private static final ClientLogger LOGGER = new ClientLogger(RunbookCreateOrUpdatePropertiesInner.class);

    public Boolean logVerbose() {
        return this.logVerbose;
    }

    public RunbookCreateOrUpdatePropertiesInner withLogVerbose(Boolean logVerbose) {
        this.logVerbose = logVerbose;
        return this;
    }

    public Boolean logProgress() {
        return this.logProgress;
    }

    public RunbookCreateOrUpdatePropertiesInner withLogProgress(Boolean logProgress) {
        this.logProgress = logProgress;
        return this;
    }

    public RunbookTypeEnum runbookType() {
        return this.runbookType;
    }

    public RunbookCreateOrUpdatePropertiesInner withRunbookType(RunbookTypeEnum runbookType) {
        this.runbookType = runbookType;
        return this;
    }

    public RunbookDraftInner draft() {
        return this.draft;
    }

    public RunbookCreateOrUpdatePropertiesInner withDraft(RunbookDraftInner draft) {
        this.draft = draft;
        return this;
    }

    public ContentLink publishContentLink() {
        return this.publishContentLink;
    }

    public RunbookCreateOrUpdatePropertiesInner withPublishContentLink(ContentLink publishContentLink) {
        this.publishContentLink = publishContentLink;
        return this;
    }

    public String description() {
        return this.description;
    }

    public RunbookCreateOrUpdatePropertiesInner withDescription(String description) {
        this.description = description;
        return this;
    }

    public Integer logActivityTrace() {
        return this.logActivityTrace;
    }

    public RunbookCreateOrUpdatePropertiesInner withLogActivityTrace(Integer logActivityTrace) {
        this.logActivityTrace = logActivityTrace;
        return this;
    }

    public void validate() {
        if (this.runbookType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property runbookType in model RunbookCreateOrUpdatePropertiesInner"));
        }
        if (this.draft() != null) {
            this.draft().validate();
        }
        if (this.publishContentLink() != null) {
            this.publishContentLink().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("runbookType", this.runbookType == null ? null : this.runbookType.toString());
        jsonWriter.writeBooleanField("logVerbose", this.logVerbose);
        jsonWriter.writeBooleanField("logProgress", this.logProgress);
        jsonWriter.writeJsonField("draft", (JsonSerializable)this.draft);
        jsonWriter.writeJsonField("publishContentLink", (JsonSerializable)this.publishContentLink);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeNumberField("logActivityTrace", (Number)this.logActivityTrace);
        return jsonWriter.writeEndObject();
    }

    public static RunbookCreateOrUpdatePropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return (RunbookCreateOrUpdatePropertiesInner)jsonReader.readObject(reader -> {
            RunbookCreateOrUpdatePropertiesInner deserializedRunbookCreateOrUpdatePropertiesInner = new RunbookCreateOrUpdatePropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("runbookType".equals(fieldName)) {
                    deserializedRunbookCreateOrUpdatePropertiesInner.runbookType = RunbookTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("logVerbose".equals(fieldName)) {
                    deserializedRunbookCreateOrUpdatePropertiesInner.logVerbose = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("logProgress".equals(fieldName)) {
                    deserializedRunbookCreateOrUpdatePropertiesInner.logProgress = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("draft".equals(fieldName)) {
                    deserializedRunbookCreateOrUpdatePropertiesInner.draft = RunbookDraftInner.fromJson(reader);
                    continue;
                }
                if ("publishContentLink".equals(fieldName)) {
                    deserializedRunbookCreateOrUpdatePropertiesInner.publishContentLink = ContentLink.fromJson(reader);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedRunbookCreateOrUpdatePropertiesInner.description = reader.getString();
                    continue;
                }
                if ("logActivityTrace".equals(fieldName)) {
                    deserializedRunbookCreateOrUpdatePropertiesInner.logActivityTrace = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRunbookCreateOrUpdatePropertiesInner;
        });
    }
}

