/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.ContentLink;
import com.azure.resourcemanager.automation.models.RunbookParameter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public final class RunbookDraftInner
implements JsonSerializable<RunbookDraftInner> {
    private Boolean inEdit;
    private ContentLink draftContentLink;
    private OffsetDateTime creationTime;
    private OffsetDateTime lastModifiedTime;
    private Map<String, RunbookParameter> parameters;
    private List<String> outputTypes;

    public Boolean inEdit() {
        return this.inEdit;
    }

    public RunbookDraftInner withInEdit(Boolean inEdit) {
        this.inEdit = inEdit;
        return this;
    }

    public ContentLink draftContentLink() {
        return this.draftContentLink;
    }

    public RunbookDraftInner withDraftContentLink(ContentLink draftContentLink) {
        this.draftContentLink = draftContentLink;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public RunbookDraftInner withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public RunbookDraftInner withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public Map<String, RunbookParameter> parameters() {
        return this.parameters;
    }

    public RunbookDraftInner withParameters(Map<String, RunbookParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public List<String> outputTypes() {
        return this.outputTypes;
    }

    public RunbookDraftInner withOutputTypes(List<String> outputTypes) {
        this.outputTypes = outputTypes;
        return this;
    }

    public void validate() {
        if (this.draftContentLink() != null) {
            this.draftContentLink().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("inEdit", this.inEdit);
        jsonWriter.writeJsonField("draftContentLink", (JsonSerializable)this.draftContentLink);
        jsonWriter.writeStringField("creationTime", this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        jsonWriter.writeStringField("lastModifiedTime", this.lastModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputTypes", this.outputTypes, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static RunbookDraftInner fromJson(JsonReader jsonReader) throws IOException {
        return (RunbookDraftInner)jsonReader.readObject(reader -> {
            RunbookDraftInner deserializedRunbookDraftInner = new RunbookDraftInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("inEdit".equals(fieldName)) {
                    deserializedRunbookDraftInner.inEdit = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("draftContentLink".equals(fieldName)) {
                    deserializedRunbookDraftInner.draftContentLink = ContentLink.fromJson(reader);
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedRunbookDraftInner.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedRunbookDraftInner.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedRunbookDraftInner.parameters = parameters = reader.readMap(reader1 -> RunbookParameter.fromJson(reader1));
                    continue;
                }
                if ("outputTypes".equals(fieldName)) {
                    List outputTypes;
                    deserializedRunbookDraftInner.outputTypes = outputTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRunbookDraftInner;
        });
    }
}

