/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.RunbookDraftInner;
import com.azure.resourcemanager.automation.fluent.models.RunbookPropertiesInner;
import com.azure.resourcemanager.automation.models.ContentLink;
import com.azure.resourcemanager.automation.models.RunbookParameter;
import com.azure.resourcemanager.automation.models.RunbookProvisioningState;
import com.azure.resourcemanager.automation.models.RunbookState;
import com.azure.resourcemanager.automation.models.RunbookTypeEnum;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class RunbookInner
extends Resource {
    private RunbookPropertiesInner innerProperties;
    private String etag;
    private String type;
    private String name;
    private String id;

    private RunbookPropertiesInner innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public RunbookInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public RunbookInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public RunbookInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public RunbookTypeEnum runbookType() {
        return this.innerProperties() == null ? null : this.innerProperties().runbookType();
    }

    public RunbookInner withRunbookType(RunbookTypeEnum runbookType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunbookPropertiesInner();
        }
        this.innerProperties().withRunbookType(runbookType);
        return this;
    }

    public ContentLink publishContentLink() {
        return this.innerProperties() == null ? null : this.innerProperties().publishContentLink();
    }

    public RunbookInner withPublishContentLink(ContentLink publishContentLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunbookPropertiesInner();
        }
        this.innerProperties().withPublishContentLink(publishContentLink);
        return this;
    }

    public RunbookState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public RunbookInner withState(RunbookState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunbookPropertiesInner();
        }
        this.innerProperties().withState(state);
        return this;
    }

    public Boolean logVerbose() {
        return this.innerProperties() == null ? null : this.innerProperties().logVerbose();
    }

    public RunbookInner withLogVerbose(Boolean logVerbose) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunbookPropertiesInner();
        }
        this.innerProperties().withLogVerbose(logVerbose);
        return this;
    }

    public Boolean logProgress() {
        return this.innerProperties() == null ? null : this.innerProperties().logProgress();
    }

    public RunbookInner withLogProgress(Boolean logProgress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunbookPropertiesInner();
        }
        this.innerProperties().withLogProgress(logProgress);
        return this;
    }

    public Integer logActivityTrace() {
        return this.innerProperties() == null ? null : this.innerProperties().logActivityTrace();
    }

    public RunbookInner withLogActivityTrace(Integer logActivityTrace) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunbookPropertiesInner();
        }
        this.innerProperties().withLogActivityTrace(logActivityTrace);
        return this;
    }

    public Integer jobCount() {
        return this.innerProperties() == null ? null : this.innerProperties().jobCount();
    }

    public RunbookInner withJobCount(Integer jobCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunbookPropertiesInner();
        }
        this.innerProperties().withJobCount(jobCount);
        return this;
    }

    public Map<String, RunbookParameter> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public RunbookInner withParameters(Map<String, RunbookParameter> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunbookPropertiesInner();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public List<String> outputTypes() {
        return this.innerProperties() == null ? null : this.innerProperties().outputTypes();
    }

    public RunbookInner withOutputTypes(List<String> outputTypes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunbookPropertiesInner();
        }
        this.innerProperties().withOutputTypes(outputTypes);
        return this;
    }

    public RunbookDraftInner draft() {
        return this.innerProperties() == null ? null : this.innerProperties().draft();
    }

    public RunbookInner withDraft(RunbookDraftInner draft) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunbookPropertiesInner();
        }
        this.innerProperties().withDraft(draft);
        return this;
    }

    public RunbookProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public RunbookInner withProvisioningState(RunbookProvisioningState provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunbookPropertiesInner();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    public String lastModifiedBy() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedBy();
    }

    public RunbookInner withLastModifiedBy(String lastModifiedBy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunbookPropertiesInner();
        }
        this.innerProperties().withLastModifiedBy(lastModifiedBy);
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public RunbookInner withCreationTime(OffsetDateTime creationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunbookPropertiesInner();
        }
        this.innerProperties().withCreationTime(creationTime);
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public RunbookInner withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunbookPropertiesInner();
        }
        this.innerProperties().withLastModifiedTime(lastModifiedTime);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public RunbookInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunbookPropertiesInner();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("etag", this.etag);
        return jsonWriter.writeEndObject();
    }

    public static RunbookInner fromJson(JsonReader jsonReader) throws IOException {
        return (RunbookInner)((Object)jsonReader.readObject(reader -> {
            RunbookInner deserializedRunbookInner = new RunbookInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRunbookInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRunbookInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRunbookInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedRunbookInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedRunbookInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRunbookInner.innerProperties = RunbookPropertiesInner.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedRunbookInner.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRunbookInner;
        }));
    }
}

