/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.RunbookDraftInner;
import com.azure.resourcemanager.automation.models.ContentLink;
import com.azure.resourcemanager.automation.models.RunbookParameter;
import com.azure.resourcemanager.automation.models.RunbookProvisioningState;
import com.azure.resourcemanager.automation.models.RunbookState;
import com.azure.resourcemanager.automation.models.RunbookTypeEnum;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public final class RunbookPropertiesInner
implements JsonSerializable<RunbookPropertiesInner> {
    private RunbookTypeEnum runbookType;
    private ContentLink publishContentLink;
    private RunbookState state;
    private Boolean logVerbose;
    private Boolean logProgress;
    private Integer logActivityTrace;
    private Integer jobCount;
    private Map<String, RunbookParameter> parameters;
    private List<String> outputTypes;
    private RunbookDraftInner draft;
    private RunbookProvisioningState provisioningState;
    private String lastModifiedBy;
    private OffsetDateTime creationTime;
    private OffsetDateTime lastModifiedTime;
    private String description;

    public RunbookTypeEnum runbookType() {
        return this.runbookType;
    }

    public RunbookPropertiesInner withRunbookType(RunbookTypeEnum runbookType) {
        this.runbookType = runbookType;
        return this;
    }

    public ContentLink publishContentLink() {
        return this.publishContentLink;
    }

    public RunbookPropertiesInner withPublishContentLink(ContentLink publishContentLink) {
        this.publishContentLink = publishContentLink;
        return this;
    }

    public RunbookState state() {
        return this.state;
    }

    public RunbookPropertiesInner withState(RunbookState state) {
        this.state = state;
        return this;
    }

    public Boolean logVerbose() {
        return this.logVerbose;
    }

    public RunbookPropertiesInner withLogVerbose(Boolean logVerbose) {
        this.logVerbose = logVerbose;
        return this;
    }

    public Boolean logProgress() {
        return this.logProgress;
    }

    public RunbookPropertiesInner withLogProgress(Boolean logProgress) {
        this.logProgress = logProgress;
        return this;
    }

    public Integer logActivityTrace() {
        return this.logActivityTrace;
    }

    public RunbookPropertiesInner withLogActivityTrace(Integer logActivityTrace) {
        this.logActivityTrace = logActivityTrace;
        return this;
    }

    public Integer jobCount() {
        return this.jobCount;
    }

    public RunbookPropertiesInner withJobCount(Integer jobCount) {
        this.jobCount = jobCount;
        return this;
    }

    public Map<String, RunbookParameter> parameters() {
        return this.parameters;
    }

    public RunbookPropertiesInner withParameters(Map<String, RunbookParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public List<String> outputTypes() {
        return this.outputTypes;
    }

    public RunbookPropertiesInner withOutputTypes(List<String> outputTypes) {
        this.outputTypes = outputTypes;
        return this;
    }

    public RunbookDraftInner draft() {
        return this.draft;
    }

    public RunbookPropertiesInner withDraft(RunbookDraftInner draft) {
        this.draft = draft;
        return this;
    }

    public RunbookProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public RunbookPropertiesInner withProvisioningState(RunbookProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public RunbookPropertiesInner withLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public RunbookPropertiesInner withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public RunbookPropertiesInner withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public String description() {
        return this.description;
    }

    public RunbookPropertiesInner withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.publishContentLink() != null) {
            this.publishContentLink().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.draft() != null) {
            this.draft().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("runbookType", this.runbookType == null ? null : this.runbookType.toString());
        jsonWriter.writeJsonField("publishContentLink", (JsonSerializable)this.publishContentLink);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeBooleanField("logVerbose", this.logVerbose);
        jsonWriter.writeBooleanField("logProgress", this.logProgress);
        jsonWriter.writeNumberField("logActivityTrace", (Number)this.logActivityTrace);
        jsonWriter.writeNumberField("jobCount", (Number)this.jobCount);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputTypes", this.outputTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("draft", (JsonSerializable)this.draft);
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeStringField("lastModifiedBy", this.lastModifiedBy);
        jsonWriter.writeStringField("creationTime", this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        jsonWriter.writeStringField("lastModifiedTime", this.lastModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static RunbookPropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return (RunbookPropertiesInner)jsonReader.readObject(reader -> {
            RunbookPropertiesInner deserializedRunbookPropertiesInner = new RunbookPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("runbookType".equals(fieldName)) {
                    deserializedRunbookPropertiesInner.runbookType = RunbookTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("publishContentLink".equals(fieldName)) {
                    deserializedRunbookPropertiesInner.publishContentLink = ContentLink.fromJson(reader);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedRunbookPropertiesInner.state = RunbookState.fromString(reader.getString());
                    continue;
                }
                if ("logVerbose".equals(fieldName)) {
                    deserializedRunbookPropertiesInner.logVerbose = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("logProgress".equals(fieldName)) {
                    deserializedRunbookPropertiesInner.logProgress = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("logActivityTrace".equals(fieldName)) {
                    deserializedRunbookPropertiesInner.logActivityTrace = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("jobCount".equals(fieldName)) {
                    deserializedRunbookPropertiesInner.jobCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedRunbookPropertiesInner.parameters = parameters = reader.readMap(reader1 -> RunbookParameter.fromJson(reader1));
                    continue;
                }
                if ("outputTypes".equals(fieldName)) {
                    List outputTypes;
                    deserializedRunbookPropertiesInner.outputTypes = outputTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("draft".equals(fieldName)) {
                    deserializedRunbookPropertiesInner.draft = RunbookDraftInner.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRunbookPropertiesInner.provisioningState = RunbookProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedRunbookPropertiesInner.lastModifiedBy = reader.getString();
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedRunbookPropertiesInner.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedRunbookPropertiesInner.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedRunbookPropertiesInner.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRunbookPropertiesInner;
        });
    }
}

