/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.AdvancedSchedule;
import com.azure.resourcemanager.automation.models.ScheduleFrequency;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ScheduleCreateOrUpdateProperties
implements JsonSerializable<ScheduleCreateOrUpdateProperties> {
    private String description;
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private Object interval;
    private ScheduleFrequency frequency;
    private String timeZone;
    private AdvancedSchedule advancedSchedule;
    private static final ClientLogger LOGGER = new ClientLogger(ScheduleCreateOrUpdateProperties.class);

    public String description() {
        return this.description;
    }

    public ScheduleCreateOrUpdateProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public ScheduleCreateOrUpdateProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    public ScheduleCreateOrUpdateProperties withExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public Object interval() {
        return this.interval;
    }

    public ScheduleCreateOrUpdateProperties withInterval(Object interval) {
        this.interval = interval;
        return this;
    }

    public ScheduleFrequency frequency() {
        return this.frequency;
    }

    public ScheduleCreateOrUpdateProperties withFrequency(ScheduleFrequency frequency) {
        this.frequency = frequency;
        return this;
    }

    public String timeZone() {
        return this.timeZone;
    }

    public ScheduleCreateOrUpdateProperties withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public AdvancedSchedule advancedSchedule() {
        return this.advancedSchedule;
    }

    public ScheduleCreateOrUpdateProperties withAdvancedSchedule(AdvancedSchedule advancedSchedule) {
        this.advancedSchedule = advancedSchedule;
        return this;
    }

    public void validate() {
        if (this.startTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property startTime in model ScheduleCreateOrUpdateProperties"));
        }
        if (this.frequency() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property frequency in model ScheduleCreateOrUpdateProperties"));
        }
        if (this.advancedSchedule() != null) {
            this.advancedSchedule().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("frequency", this.frequency == null ? null : this.frequency.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("expiryTime", this.expiryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiryTime));
        jsonWriter.writeUntypedField("interval", this.interval);
        jsonWriter.writeStringField("timeZone", this.timeZone);
        jsonWriter.writeJsonField("advancedSchedule", (JsonSerializable)this.advancedSchedule);
        return jsonWriter.writeEndObject();
    }

    public static ScheduleCreateOrUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduleCreateOrUpdateProperties)jsonReader.readObject(reader -> {
            ScheduleCreateOrUpdateProperties deserializedScheduleCreateOrUpdateProperties = new ScheduleCreateOrUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedScheduleCreateOrUpdateProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("frequency".equals(fieldName)) {
                    deserializedScheduleCreateOrUpdateProperties.frequency = ScheduleFrequency.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedScheduleCreateOrUpdateProperties.description = reader.getString();
                    continue;
                }
                if ("expiryTime".equals(fieldName)) {
                    deserializedScheduleCreateOrUpdateProperties.expiryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    deserializedScheduleCreateOrUpdateProperties.interval = reader.readUntyped();
                    continue;
                }
                if ("timeZone".equals(fieldName)) {
                    deserializedScheduleCreateOrUpdateProperties.timeZone = reader.getString();
                    continue;
                }
                if ("advancedSchedule".equals(fieldName)) {
                    deserializedScheduleCreateOrUpdateProperties.advancedSchedule = AdvancedSchedule.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScheduleCreateOrUpdateProperties;
        });
    }
}

