/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.ScheduleProperties;
import com.azure.resourcemanager.automation.models.AdvancedSchedule;
import com.azure.resourcemanager.automation.models.ScheduleFrequency;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ScheduleInner
extends ProxyResource {
    private ScheduleProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private ScheduleProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public ScheduleInner withStartTime(OffsetDateTime startTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleProperties();
        }
        this.innerProperties().withStartTime(startTime);
        return this;
    }

    public Double startTimeOffsetMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().startTimeOffsetMinutes();
    }

    public OffsetDateTime expiryTime() {
        return this.innerProperties() == null ? null : this.innerProperties().expiryTime();
    }

    public ScheduleInner withExpiryTime(OffsetDateTime expiryTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleProperties();
        }
        this.innerProperties().withExpiryTime(expiryTime);
        return this;
    }

    public Double expiryTimeOffsetMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().expiryTimeOffsetMinutes();
    }

    public ScheduleInner withExpiryTimeOffsetMinutes(Double expiryTimeOffsetMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleProperties();
        }
        this.innerProperties().withExpiryTimeOffsetMinutes(expiryTimeOffsetMinutes);
        return this;
    }

    public Boolean isEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isEnabled();
    }

    public ScheduleInner withIsEnabled(Boolean isEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleProperties();
        }
        this.innerProperties().withIsEnabled(isEnabled);
        return this;
    }

    public OffsetDateTime nextRun() {
        return this.innerProperties() == null ? null : this.innerProperties().nextRun();
    }

    public ScheduleInner withNextRun(OffsetDateTime nextRun) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleProperties();
        }
        this.innerProperties().withNextRun(nextRun);
        return this;
    }

    public Double nextRunOffsetMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().nextRunOffsetMinutes();
    }

    public ScheduleInner withNextRunOffsetMinutes(Double nextRunOffsetMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleProperties();
        }
        this.innerProperties().withNextRunOffsetMinutes(nextRunOffsetMinutes);
        return this;
    }

    public Object interval() {
        return this.innerProperties() == null ? null : this.innerProperties().interval();
    }

    public ScheduleInner withInterval(Object interval) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleProperties();
        }
        this.innerProperties().withInterval(interval);
        return this;
    }

    public ScheduleFrequency frequency() {
        return this.innerProperties() == null ? null : this.innerProperties().frequency();
    }

    public ScheduleInner withFrequency(ScheduleFrequency frequency) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleProperties();
        }
        this.innerProperties().withFrequency(frequency);
        return this;
    }

    public String timeZone() {
        return this.innerProperties() == null ? null : this.innerProperties().timeZone();
    }

    public ScheduleInner withTimeZone(String timeZone) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleProperties();
        }
        this.innerProperties().withTimeZone(timeZone);
        return this;
    }

    public AdvancedSchedule advancedSchedule() {
        return this.innerProperties() == null ? null : this.innerProperties().advancedSchedule();
    }

    public ScheduleInner withAdvancedSchedule(AdvancedSchedule advancedSchedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleProperties();
        }
        this.innerProperties().withAdvancedSchedule(advancedSchedule);
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public ScheduleInner withCreationTime(OffsetDateTime creationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleProperties();
        }
        this.innerProperties().withCreationTime(creationTime);
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public ScheduleInner withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleProperties();
        }
        this.innerProperties().withLastModifiedTime(lastModifiedTime);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ScheduleInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ScheduleInner fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduleInner)((Object)jsonReader.readObject(reader -> {
            ScheduleInner deserializedScheduleInner = new ScheduleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedScheduleInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedScheduleInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedScheduleInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedScheduleInner.innerProperties = ScheduleProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScheduleInner;
        }));
    }
}

