/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.AdvancedSchedule;
import com.azure.resourcemanager.automation.models.ScheduleFrequency;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ScheduleProperties
implements JsonSerializable<ScheduleProperties> {
    private OffsetDateTime startTime;
    private Double startTimeOffsetMinutes;
    private OffsetDateTime expiryTime;
    private Double expiryTimeOffsetMinutes;
    private Boolean isEnabled;
    private OffsetDateTime nextRun;
    private Double nextRunOffsetMinutes;
    private Object interval;
    private ScheduleFrequency frequency;
    private String timeZone;
    private AdvancedSchedule advancedSchedule;
    private OffsetDateTime creationTime;
    private OffsetDateTime lastModifiedTime;
    private String description;

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public ScheduleProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public Double startTimeOffsetMinutes() {
        return this.startTimeOffsetMinutes;
    }

    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    public ScheduleProperties withExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public Double expiryTimeOffsetMinutes() {
        return this.expiryTimeOffsetMinutes;
    }

    public ScheduleProperties withExpiryTimeOffsetMinutes(Double expiryTimeOffsetMinutes) {
        this.expiryTimeOffsetMinutes = expiryTimeOffsetMinutes;
        return this;
    }

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public ScheduleProperties withIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public OffsetDateTime nextRun() {
        return this.nextRun;
    }

    public ScheduleProperties withNextRun(OffsetDateTime nextRun) {
        this.nextRun = nextRun;
        return this;
    }

    public Double nextRunOffsetMinutes() {
        return this.nextRunOffsetMinutes;
    }

    public ScheduleProperties withNextRunOffsetMinutes(Double nextRunOffsetMinutes) {
        this.nextRunOffsetMinutes = nextRunOffsetMinutes;
        return this;
    }

    public Object interval() {
        return this.interval;
    }

    public ScheduleProperties withInterval(Object interval) {
        this.interval = interval;
        return this;
    }

    public ScheduleFrequency frequency() {
        return this.frequency;
    }

    public ScheduleProperties withFrequency(ScheduleFrequency frequency) {
        this.frequency = frequency;
        return this;
    }

    public String timeZone() {
        return this.timeZone;
    }

    public ScheduleProperties withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public AdvancedSchedule advancedSchedule() {
        return this.advancedSchedule;
    }

    public ScheduleProperties withAdvancedSchedule(AdvancedSchedule advancedSchedule) {
        this.advancedSchedule = advancedSchedule;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public ScheduleProperties withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public ScheduleProperties withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ScheduleProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.advancedSchedule() != null) {
            this.advancedSchedule().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("expiryTime", this.expiryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiryTime));
        jsonWriter.writeNumberField("expiryTimeOffsetMinutes", (Number)this.expiryTimeOffsetMinutes);
        jsonWriter.writeBooleanField("isEnabled", this.isEnabled);
        jsonWriter.writeStringField("nextRun", this.nextRun == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.nextRun));
        jsonWriter.writeNumberField("nextRunOffsetMinutes", (Number)this.nextRunOffsetMinutes);
        jsonWriter.writeUntypedField("interval", this.interval);
        jsonWriter.writeStringField("frequency", this.frequency == null ? null : this.frequency.toString());
        jsonWriter.writeStringField("timeZone", this.timeZone);
        jsonWriter.writeJsonField("advancedSchedule", (JsonSerializable)this.advancedSchedule);
        jsonWriter.writeStringField("creationTime", this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        jsonWriter.writeStringField("lastModifiedTime", this.lastModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static ScheduleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduleProperties)jsonReader.readObject(reader -> {
            ScheduleProperties deserializedScheduleProperties = new ScheduleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedScheduleProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("startTimeOffsetMinutes".equals(fieldName)) {
                    deserializedScheduleProperties.startTimeOffsetMinutes = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("expiryTime".equals(fieldName)) {
                    deserializedScheduleProperties.expiryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("expiryTimeOffsetMinutes".equals(fieldName)) {
                    deserializedScheduleProperties.expiryTimeOffsetMinutes = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("isEnabled".equals(fieldName)) {
                    deserializedScheduleProperties.isEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("nextRun".equals(fieldName)) {
                    deserializedScheduleProperties.nextRun = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("nextRunOffsetMinutes".equals(fieldName)) {
                    deserializedScheduleProperties.nextRunOffsetMinutes = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    deserializedScheduleProperties.interval = reader.readUntyped();
                    continue;
                }
                if ("frequency".equals(fieldName)) {
                    deserializedScheduleProperties.frequency = ScheduleFrequency.fromString(reader.getString());
                    continue;
                }
                if ("timeZone".equals(fieldName)) {
                    deserializedScheduleProperties.timeZone = reader.getString();
                    continue;
                }
                if ("advancedSchedule".equals(fieldName)) {
                    deserializedScheduleProperties.advancedSchedule = AdvancedSchedule.fromJson(reader);
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedScheduleProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedScheduleProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedScheduleProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScheduleProperties;
        });
    }
}

