/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.ScheduleFrequency;
import com.azure.resourcemanager.automation.models.SoftwareUpdateConfigurationTasks;
import com.azure.resourcemanager.automation.models.UpdateConfiguration;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class SoftwareUpdateConfigurationCollectionItemProperties
implements JsonSerializable<SoftwareUpdateConfigurationCollectionItemProperties> {
    private UpdateConfiguration updateConfiguration;
    private SoftwareUpdateConfigurationTasks tasks;
    private ScheduleFrequency frequency;
    private OffsetDateTime startTime;
    private OffsetDateTime creationTime;
    private OffsetDateTime lastModifiedTime;
    private String provisioningState;
    private OffsetDateTime nextRun;

    public UpdateConfiguration updateConfiguration() {
        return this.updateConfiguration;
    }

    public SoftwareUpdateConfigurationCollectionItemProperties withUpdateConfiguration(UpdateConfiguration updateConfiguration) {
        this.updateConfiguration = updateConfiguration;
        return this;
    }

    public SoftwareUpdateConfigurationTasks tasks() {
        return this.tasks;
    }

    public SoftwareUpdateConfigurationCollectionItemProperties withTasks(SoftwareUpdateConfigurationTasks tasks) {
        this.tasks = tasks;
        return this;
    }

    public ScheduleFrequency frequency() {
        return this.frequency;
    }

    public SoftwareUpdateConfigurationCollectionItemProperties withFrequency(ScheduleFrequency frequency) {
        this.frequency = frequency;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public SoftwareUpdateConfigurationCollectionItemProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime nextRun() {
        return this.nextRun;
    }

    public SoftwareUpdateConfigurationCollectionItemProperties withNextRun(OffsetDateTime nextRun) {
        this.nextRun = nextRun;
        return this;
    }

    public void validate() {
        if (this.updateConfiguration() != null) {
            this.updateConfiguration().validate();
        }
        if (this.tasks() != null) {
            this.tasks().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("updateConfiguration", (JsonSerializable)this.updateConfiguration);
        jsonWriter.writeJsonField("tasks", (JsonSerializable)this.tasks);
        jsonWriter.writeStringField("frequency", this.frequency == null ? null : this.frequency.toString());
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("nextRun", this.nextRun == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.nextRun));
        return jsonWriter.writeEndObject();
    }

    public static SoftwareUpdateConfigurationCollectionItemProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SoftwareUpdateConfigurationCollectionItemProperties)jsonReader.readObject(reader -> {
            SoftwareUpdateConfigurationCollectionItemProperties deserializedSoftwareUpdateConfigurationCollectionItemProperties = new SoftwareUpdateConfigurationCollectionItemProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("updateConfiguration".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationCollectionItemProperties.updateConfiguration = UpdateConfiguration.fromJson(reader);
                    continue;
                }
                if ("tasks".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationCollectionItemProperties.tasks = SoftwareUpdateConfigurationTasks.fromJson(reader);
                    continue;
                }
                if ("frequency".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationCollectionItemProperties.frequency = ScheduleFrequency.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationCollectionItemProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationCollectionItemProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationCollectionItemProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationCollectionItemProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("nextRun".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationCollectionItemProperties.nextRun = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSoftwareUpdateConfigurationCollectionItemProperties;
        });
    }
}

