/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.SoftwareUpdateConfigurationProperties;
import com.azure.resourcemanager.automation.models.SoftwareUpdateConfigurationTasks;
import com.azure.resourcemanager.automation.models.SucScheduleProperties;
import com.azure.resourcemanager.automation.models.UpdateConfiguration;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SoftwareUpdateConfigurationInner
extends ProxyResource {
    private SoftwareUpdateConfigurationProperties innerProperties = new SoftwareUpdateConfigurationProperties();
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(SoftwareUpdateConfigurationInner.class);

    private SoftwareUpdateConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public UpdateConfiguration updateConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().updateConfiguration();
    }

    public SoftwareUpdateConfigurationInner withUpdateConfiguration(UpdateConfiguration updateConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SoftwareUpdateConfigurationProperties();
        }
        this.innerProperties().withUpdateConfiguration(updateConfiguration);
        return this;
    }

    public SucScheduleProperties scheduleInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().scheduleInfo();
    }

    public SoftwareUpdateConfigurationInner withScheduleInfo(SucScheduleProperties scheduleInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SoftwareUpdateConfigurationProperties();
        }
        this.innerProperties().withScheduleInfo(scheduleInfo);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public ManagementError error() {
        return this.innerProperties() == null ? null : this.innerProperties().error();
    }

    public SoftwareUpdateConfigurationInner withError(ManagementError error) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SoftwareUpdateConfigurationProperties();
        }
        this.innerProperties().withError(error);
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public String createdBy() {
        return this.innerProperties() == null ? null : this.innerProperties().createdBy();
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public String lastModifiedBy() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedBy();
    }

    public SoftwareUpdateConfigurationTasks tasks() {
        return this.innerProperties() == null ? null : this.innerProperties().tasks();
    }

    public SoftwareUpdateConfigurationInner withTasks(SoftwareUpdateConfigurationTasks tasks) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SoftwareUpdateConfigurationProperties();
        }
        this.innerProperties().withTasks(tasks);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model SoftwareUpdateConfigurationInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SoftwareUpdateConfigurationInner fromJson(JsonReader jsonReader) throws IOException {
        return (SoftwareUpdateConfigurationInner)((Object)jsonReader.readObject(reader -> {
            SoftwareUpdateConfigurationInner deserializedSoftwareUpdateConfigurationInner = new SoftwareUpdateConfigurationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationInner.innerProperties = SoftwareUpdateConfigurationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSoftwareUpdateConfigurationInner;
        }));
    }
}

