/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.SoftwareUpdateConfigurationTasks;
import com.azure.resourcemanager.automation.models.SucScheduleProperties;
import com.azure.resourcemanager.automation.models.UpdateConfiguration;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SoftwareUpdateConfigurationProperties
implements JsonSerializable<SoftwareUpdateConfigurationProperties> {
    private UpdateConfiguration updateConfiguration;
    private SucScheduleProperties scheduleInfo;
    private String provisioningState;
    private ManagementError error;
    private OffsetDateTime creationTime;
    private String createdBy;
    private OffsetDateTime lastModifiedTime;
    private String lastModifiedBy;
    private SoftwareUpdateConfigurationTasks tasks;
    private static final ClientLogger LOGGER = new ClientLogger(SoftwareUpdateConfigurationProperties.class);

    public UpdateConfiguration updateConfiguration() {
        return this.updateConfiguration;
    }

    public SoftwareUpdateConfigurationProperties withUpdateConfiguration(UpdateConfiguration updateConfiguration) {
        this.updateConfiguration = updateConfiguration;
        return this;
    }

    public SucScheduleProperties scheduleInfo() {
        return this.scheduleInfo;
    }

    public SoftwareUpdateConfigurationProperties withScheduleInfo(SucScheduleProperties scheduleInfo) {
        this.scheduleInfo = scheduleInfo;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public ManagementError error() {
        return this.error;
    }

    public SoftwareUpdateConfigurationProperties withError(ManagementError error) {
        this.error = error;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public String createdBy() {
        return this.createdBy;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public SoftwareUpdateConfigurationTasks tasks() {
        return this.tasks;
    }

    public SoftwareUpdateConfigurationProperties withTasks(SoftwareUpdateConfigurationTasks tasks) {
        this.tasks = tasks;
        return this;
    }

    public void validate() {
        if (this.updateConfiguration() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property updateConfiguration in model SoftwareUpdateConfigurationProperties"));
        }
        this.updateConfiguration().validate();
        if (this.scheduleInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property scheduleInfo in model SoftwareUpdateConfigurationProperties"));
        }
        this.scheduleInfo().validate();
        if (this.tasks() != null) {
            this.tasks().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("updateConfiguration", (JsonSerializable)this.updateConfiguration);
        jsonWriter.writeJsonField("scheduleInfo", (JsonSerializable)this.scheduleInfo);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeJsonField("tasks", (JsonSerializable)this.tasks);
        return jsonWriter.writeEndObject();
    }

    public static SoftwareUpdateConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SoftwareUpdateConfigurationProperties)jsonReader.readObject(reader -> {
            SoftwareUpdateConfigurationProperties deserializedSoftwareUpdateConfigurationProperties = new SoftwareUpdateConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("updateConfiguration".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationProperties.updateConfiguration = UpdateConfiguration.fromJson(reader);
                    continue;
                }
                if ("scheduleInfo".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationProperties.scheduleInfo = SucScheduleProperties.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationProperties.error = ManagementError.fromJson((JsonReader)reader);
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationProperties.createdBy = reader.getString();
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationProperties.lastModifiedBy = reader.getString();
                    continue;
                }
                if ("tasks".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationProperties.tasks = SoftwareUpdateConfigurationTasks.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSoftwareUpdateConfigurationProperties;
        });
    }
}

