/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.SoftwareUpdateConfigurationRunTasks;
import com.azure.resourcemanager.automation.models.UpdateConfigurationNavigation;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SoftwareUpdateConfigurationRunProperties
implements JsonSerializable<SoftwareUpdateConfigurationRunProperties> {
    private UpdateConfigurationNavigation softwareUpdateConfiguration;
    private String status;
    private String configuredDuration;
    private String osType;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private Integer computerCount;
    private Integer failedCount;
    private OffsetDateTime creationTime;
    private String createdBy;
    private OffsetDateTime lastModifiedTime;
    private String lastModifiedBy;
    private SoftwareUpdateConfigurationRunTasks tasks;

    public UpdateConfigurationNavigation softwareUpdateConfiguration() {
        return this.softwareUpdateConfiguration;
    }

    public SoftwareUpdateConfigurationRunProperties withSoftwareUpdateConfiguration(UpdateConfigurationNavigation softwareUpdateConfiguration) {
        this.softwareUpdateConfiguration = softwareUpdateConfiguration;
        return this;
    }

    public String status() {
        return this.status;
    }

    public String configuredDuration() {
        return this.configuredDuration;
    }

    public String osType() {
        return this.osType;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public Integer computerCount() {
        return this.computerCount;
    }

    public Integer failedCount() {
        return this.failedCount;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public String createdBy() {
        return this.createdBy;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public SoftwareUpdateConfigurationRunTasks tasks() {
        return this.tasks;
    }

    public SoftwareUpdateConfigurationRunProperties withTasks(SoftwareUpdateConfigurationRunTasks tasks) {
        this.tasks = tasks;
        return this;
    }

    public void validate() {
        if (this.softwareUpdateConfiguration() != null) {
            this.softwareUpdateConfiguration().validate();
        }
        if (this.tasks() != null) {
            this.tasks().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("softwareUpdateConfiguration", (JsonSerializable)this.softwareUpdateConfiguration);
        jsonWriter.writeJsonField("tasks", (JsonSerializable)this.tasks);
        return jsonWriter.writeEndObject();
    }

    public static SoftwareUpdateConfigurationRunProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SoftwareUpdateConfigurationRunProperties)jsonReader.readObject(reader -> {
            SoftwareUpdateConfigurationRunProperties deserializedSoftwareUpdateConfigurationRunProperties = new SoftwareUpdateConfigurationRunProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("softwareUpdateConfiguration".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationRunProperties.softwareUpdateConfiguration = UpdateConfigurationNavigation.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationRunProperties.status = reader.getString();
                    continue;
                }
                if ("configuredDuration".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationRunProperties.configuredDuration = reader.getString();
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationRunProperties.osType = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationRunProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationRunProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("computerCount".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationRunProperties.computerCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("failedCount".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationRunProperties.failedCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationRunProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationRunProperties.createdBy = reader.getString();
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationRunProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationRunProperties.lastModifiedBy = reader.getString();
                    continue;
                }
                if ("tasks".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationRunProperties.tasks = SoftwareUpdateConfigurationRunTasks.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSoftwareUpdateConfigurationRunProperties;
        });
    }
}

