/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.SourceControlSecurityTokenProperties;
import com.azure.resourcemanager.automation.models.SourceType;
import java.io.IOException;

public final class SourceControlCreateOrUpdateProperties
implements JsonSerializable<SourceControlCreateOrUpdateProperties> {
    private String repoUrl;
    private String branch;
    private String folderPath;
    private Boolean autoSync;
    private Boolean publishRunbook;
    private SourceType sourceType;
    private SourceControlSecurityTokenProperties securityToken;
    private String description;

    public String repoUrl() {
        return this.repoUrl;
    }

    public SourceControlCreateOrUpdateProperties withRepoUrl(String repoUrl) {
        this.repoUrl = repoUrl;
        return this;
    }

    public String branch() {
        return this.branch;
    }

    public SourceControlCreateOrUpdateProperties withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public String folderPath() {
        return this.folderPath;
    }

    public SourceControlCreateOrUpdateProperties withFolderPath(String folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    public Boolean autoSync() {
        return this.autoSync;
    }

    public SourceControlCreateOrUpdateProperties withAutoSync(Boolean autoSync) {
        this.autoSync = autoSync;
        return this;
    }

    public Boolean publishRunbook() {
        return this.publishRunbook;
    }

    public SourceControlCreateOrUpdateProperties withPublishRunbook(Boolean publishRunbook) {
        this.publishRunbook = publishRunbook;
        return this;
    }

    public SourceType sourceType() {
        return this.sourceType;
    }

    public SourceControlCreateOrUpdateProperties withSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public SourceControlSecurityTokenProperties securityToken() {
        return this.securityToken;
    }

    public SourceControlCreateOrUpdateProperties withSecurityToken(SourceControlSecurityTokenProperties securityToken) {
        this.securityToken = securityToken;
        return this;
    }

    public String description() {
        return this.description;
    }

    public SourceControlCreateOrUpdateProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.securityToken() != null) {
            this.securityToken().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("repoUrl", this.repoUrl);
        jsonWriter.writeStringField("branch", this.branch);
        jsonWriter.writeStringField("folderPath", this.folderPath);
        jsonWriter.writeBooleanField("autoSync", this.autoSync);
        jsonWriter.writeBooleanField("publishRunbook", this.publishRunbook);
        jsonWriter.writeStringField("sourceType", this.sourceType == null ? null : this.sourceType.toString());
        jsonWriter.writeJsonField("securityToken", (JsonSerializable)this.securityToken);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static SourceControlCreateOrUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SourceControlCreateOrUpdateProperties)jsonReader.readObject(reader -> {
            SourceControlCreateOrUpdateProperties deserializedSourceControlCreateOrUpdateProperties = new SourceControlCreateOrUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("repoUrl".equals(fieldName)) {
                    deserializedSourceControlCreateOrUpdateProperties.repoUrl = reader.getString();
                    continue;
                }
                if ("branch".equals(fieldName)) {
                    deserializedSourceControlCreateOrUpdateProperties.branch = reader.getString();
                    continue;
                }
                if ("folderPath".equals(fieldName)) {
                    deserializedSourceControlCreateOrUpdateProperties.folderPath = reader.getString();
                    continue;
                }
                if ("autoSync".equals(fieldName)) {
                    deserializedSourceControlCreateOrUpdateProperties.autoSync = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publishRunbook".equals(fieldName)) {
                    deserializedSourceControlCreateOrUpdateProperties.publishRunbook = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("sourceType".equals(fieldName)) {
                    deserializedSourceControlCreateOrUpdateProperties.sourceType = SourceType.fromString(reader.getString());
                    continue;
                }
                if ("securityToken".equals(fieldName)) {
                    deserializedSourceControlCreateOrUpdateProperties.securityToken = SourceControlSecurityTokenProperties.fromJson(reader);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSourceControlCreateOrUpdateProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceControlCreateOrUpdateProperties;
        });
    }
}

