/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.SourceControlProperties;
import com.azure.resourcemanager.automation.models.SourceType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SourceControlInner
extends ProxyResource {
    private SourceControlProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private SourceControlProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String repoUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().repoUrl();
    }

    public SourceControlInner withRepoUrl(String repoUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlProperties();
        }
        this.innerProperties().withRepoUrl(repoUrl);
        return this;
    }

    public String branch() {
        return this.innerProperties() == null ? null : this.innerProperties().branch();
    }

    public SourceControlInner withBranch(String branch) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlProperties();
        }
        this.innerProperties().withBranch(branch);
        return this;
    }

    public String folderPath() {
        return this.innerProperties() == null ? null : this.innerProperties().folderPath();
    }

    public SourceControlInner withFolderPath(String folderPath) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlProperties();
        }
        this.innerProperties().withFolderPath(folderPath);
        return this;
    }

    public Boolean autoSync() {
        return this.innerProperties() == null ? null : this.innerProperties().autoSync();
    }

    public SourceControlInner withAutoSync(Boolean autoSync) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlProperties();
        }
        this.innerProperties().withAutoSync(autoSync);
        return this;
    }

    public Boolean publishRunbook() {
        return this.innerProperties() == null ? null : this.innerProperties().publishRunbook();
    }

    public SourceControlInner withPublishRunbook(Boolean publishRunbook) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlProperties();
        }
        this.innerProperties().withPublishRunbook(publishRunbook);
        return this;
    }

    public SourceType sourceType() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceType();
    }

    public SourceControlInner withSourceType(SourceType sourceType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlProperties();
        }
        this.innerProperties().withSourceType(sourceType);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public SourceControlInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public SourceControlInner withCreationTime(OffsetDateTime creationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlProperties();
        }
        this.innerProperties().withCreationTime(creationTime);
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public SourceControlInner withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlProperties();
        }
        this.innerProperties().withLastModifiedTime(lastModifiedTime);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SourceControlInner fromJson(JsonReader jsonReader) throws IOException {
        return (SourceControlInner)((Object)jsonReader.readObject(reader -> {
            SourceControlInner deserializedSourceControlInner = new SourceControlInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSourceControlInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSourceControlInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSourceControlInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSourceControlInner.innerProperties = SourceControlProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceControlInner;
        }));
    }
}

