/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.SourceType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class SourceControlProperties
implements JsonSerializable<SourceControlProperties> {
    private String repoUrl;
    private String branch;
    private String folderPath;
    private Boolean autoSync;
    private Boolean publishRunbook;
    private SourceType sourceType;
    private String description;
    private OffsetDateTime creationTime;
    private OffsetDateTime lastModifiedTime;

    public String repoUrl() {
        return this.repoUrl;
    }

    public SourceControlProperties withRepoUrl(String repoUrl) {
        this.repoUrl = repoUrl;
        return this;
    }

    public String branch() {
        return this.branch;
    }

    public SourceControlProperties withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public String folderPath() {
        return this.folderPath;
    }

    public SourceControlProperties withFolderPath(String folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    public Boolean autoSync() {
        return this.autoSync;
    }

    public SourceControlProperties withAutoSync(Boolean autoSync) {
        this.autoSync = autoSync;
        return this;
    }

    public Boolean publishRunbook() {
        return this.publishRunbook;
    }

    public SourceControlProperties withPublishRunbook(Boolean publishRunbook) {
        this.publishRunbook = publishRunbook;
        return this;
    }

    public SourceType sourceType() {
        return this.sourceType;
    }

    public SourceControlProperties withSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public String description() {
        return this.description;
    }

    public SourceControlProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public SourceControlProperties withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public SourceControlProperties withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("repoUrl", this.repoUrl);
        jsonWriter.writeStringField("branch", this.branch);
        jsonWriter.writeStringField("folderPath", this.folderPath);
        jsonWriter.writeBooleanField("autoSync", this.autoSync);
        jsonWriter.writeBooleanField("publishRunbook", this.publishRunbook);
        jsonWriter.writeStringField("sourceType", this.sourceType == null ? null : this.sourceType.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("creationTime", this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        jsonWriter.writeStringField("lastModifiedTime", this.lastModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        return jsonWriter.writeEndObject();
    }

    public static SourceControlProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SourceControlProperties)jsonReader.readObject(reader -> {
            SourceControlProperties deserializedSourceControlProperties = new SourceControlProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("repoUrl".equals(fieldName)) {
                    deserializedSourceControlProperties.repoUrl = reader.getString();
                    continue;
                }
                if ("branch".equals(fieldName)) {
                    deserializedSourceControlProperties.branch = reader.getString();
                    continue;
                }
                if ("folderPath".equals(fieldName)) {
                    deserializedSourceControlProperties.folderPath = reader.getString();
                    continue;
                }
                if ("autoSync".equals(fieldName)) {
                    deserializedSourceControlProperties.autoSync = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publishRunbook".equals(fieldName)) {
                    deserializedSourceControlProperties.publishRunbook = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("sourceType".equals(fieldName)) {
                    deserializedSourceControlProperties.sourceType = SourceType.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSourceControlProperties.description = reader.getString();
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedSourceControlProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedSourceControlProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceControlProperties;
        });
    }
}

