/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.ProvisioningState;
import com.azure.resourcemanager.automation.models.SyncType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SourceControlSyncJobByIdProperties
implements JsonSerializable<SourceControlSyncJobByIdProperties> {
    private String sourceControlSyncJobId;
    private OffsetDateTime creationTime;
    private ProvisioningState provisioningState;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private SyncType syncType;
    private String exception;

    public String sourceControlSyncJobId() {
        return this.sourceControlSyncJobId;
    }

    public SourceControlSyncJobByIdProperties withSourceControlSyncJobId(String sourceControlSyncJobId) {
        this.sourceControlSyncJobId = sourceControlSyncJobId;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public SourceControlSyncJobByIdProperties withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public SyncType syncType() {
        return this.syncType;
    }

    public SourceControlSyncJobByIdProperties withSyncType(SyncType syncType) {
        this.syncType = syncType;
        return this;
    }

    public String exception() {
        return this.exception;
    }

    public SourceControlSyncJobByIdProperties withException(String exception) {
        this.exception = exception;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceControlSyncJobId", this.sourceControlSyncJobId);
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeStringField("syncType", this.syncType == null ? null : this.syncType.toString());
        jsonWriter.writeStringField("exception", this.exception);
        return jsonWriter.writeEndObject();
    }

    public static SourceControlSyncJobByIdProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SourceControlSyncJobByIdProperties)jsonReader.readObject(reader -> {
            SourceControlSyncJobByIdProperties deserializedSourceControlSyncJobByIdProperties = new SourceControlSyncJobByIdProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceControlSyncJobId".equals(fieldName)) {
                    deserializedSourceControlSyncJobByIdProperties.sourceControlSyncJobId = reader.getString();
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedSourceControlSyncJobByIdProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSourceControlSyncJobByIdProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedSourceControlSyncJobByIdProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedSourceControlSyncJobByIdProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("syncType".equals(fieldName)) {
                    deserializedSourceControlSyncJobByIdProperties.syncType = SyncType.fromString(reader.getString());
                    continue;
                }
                if ("exception".equals(fieldName)) {
                    deserializedSourceControlSyncJobByIdProperties.exception = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceControlSyncJobByIdProperties;
        });
    }
}

