/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.SourceControlSyncJobProperties;
import com.azure.resourcemanager.automation.models.ProvisioningState;
import com.azure.resourcemanager.automation.models.SyncType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SourceControlSyncJobInner
implements JsonSerializable<SourceControlSyncJobInner> {
    private String name;
    private String type;
    private String id;
    private SourceControlSyncJobProperties innerProperties;

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    private SourceControlSyncJobProperties innerProperties() {
        return this.innerProperties;
    }

    public String sourceControlSyncJobId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceControlSyncJobId();
    }

    public SourceControlSyncJobInner withSourceControlSyncJobId(String sourceControlSyncJobId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlSyncJobProperties();
        }
        this.innerProperties().withSourceControlSyncJobId(sourceControlSyncJobId);
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public SourceControlSyncJobInner withProvisioningState(ProvisioningState provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlSyncJobProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    public SyncType syncType() {
        return this.innerProperties() == null ? null : this.innerProperties().syncType();
    }

    public SourceControlSyncJobInner withSyncType(SyncType syncType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlSyncJobProperties();
        }
        this.innerProperties().withSyncType(syncType);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SourceControlSyncJobInner fromJson(JsonReader jsonReader) throws IOException {
        return (SourceControlSyncJobInner)jsonReader.readObject(reader -> {
            SourceControlSyncJobInner deserializedSourceControlSyncJobInner = new SourceControlSyncJobInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSourceControlSyncJobInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSourceControlSyncJobInner.type = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedSourceControlSyncJobInner.id = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSourceControlSyncJobInner.innerProperties = SourceControlSyncJobProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceControlSyncJobInner;
        });
    }
}

