/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.ProvisioningState;
import com.azure.resourcemanager.automation.models.SyncType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SourceControlSyncJobProperties
implements JsonSerializable<SourceControlSyncJobProperties> {
    private String sourceControlSyncJobId;
    private OffsetDateTime creationTime;
    private ProvisioningState provisioningState;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private SyncType syncType;

    public String sourceControlSyncJobId() {
        return this.sourceControlSyncJobId;
    }

    public SourceControlSyncJobProperties withSourceControlSyncJobId(String sourceControlSyncJobId) {
        this.sourceControlSyncJobId = sourceControlSyncJobId;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public SourceControlSyncJobProperties withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public SyncType syncType() {
        return this.syncType;
    }

    public SourceControlSyncJobProperties withSyncType(SyncType syncType) {
        this.syncType = syncType;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceControlSyncJobId", this.sourceControlSyncJobId);
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeStringField("syncType", this.syncType == null ? null : this.syncType.toString());
        return jsonWriter.writeEndObject();
    }

    public static SourceControlSyncJobProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SourceControlSyncJobProperties)jsonReader.readObject(reader -> {
            SourceControlSyncJobProperties deserializedSourceControlSyncJobProperties = new SourceControlSyncJobProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceControlSyncJobId".equals(fieldName)) {
                    deserializedSourceControlSyncJobProperties.sourceControlSyncJobId = reader.getString();
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedSourceControlSyncJobProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSourceControlSyncJobProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedSourceControlSyncJobProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedSourceControlSyncJobProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("syncType".equals(fieldName)) {
                    deserializedSourceControlSyncJobProperties.syncType = SyncType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceControlSyncJobProperties;
        });
    }
}

