/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.StreamType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class SourceControlSyncJobStreamByIdProperties
implements JsonSerializable<SourceControlSyncJobStreamByIdProperties> {
    private String sourceControlSyncJobStreamId;
    private String summary;
    private OffsetDateTime time;
    private StreamType streamType;
    private String streamText;
    private Map<String, Object> value;

    public String sourceControlSyncJobStreamId() {
        return this.sourceControlSyncJobStreamId;
    }

    public SourceControlSyncJobStreamByIdProperties withSourceControlSyncJobStreamId(String sourceControlSyncJobStreamId) {
        this.sourceControlSyncJobStreamId = sourceControlSyncJobStreamId;
        return this;
    }

    public String summary() {
        return this.summary;
    }

    public SourceControlSyncJobStreamByIdProperties withSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public OffsetDateTime time() {
        return this.time;
    }

    public StreamType streamType() {
        return this.streamType;
    }

    public SourceControlSyncJobStreamByIdProperties withStreamType(StreamType streamType) {
        this.streamType = streamType;
        return this;
    }

    public String streamText() {
        return this.streamText;
    }

    public SourceControlSyncJobStreamByIdProperties withStreamText(String streamText) {
        this.streamText = streamText;
        return this;
    }

    public Map<String, Object> value() {
        return this.value;
    }

    public SourceControlSyncJobStreamByIdProperties withValue(Map<String, Object> value) {
        this.value = value;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceControlSyncJobStreamId", this.sourceControlSyncJobStreamId);
        jsonWriter.writeStringField("summary", this.summary);
        jsonWriter.writeStringField("streamType", this.streamType == null ? null : this.streamType.toString());
        jsonWriter.writeStringField("streamText", this.streamText);
        jsonWriter.writeMapField("value", this.value, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static SourceControlSyncJobStreamByIdProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SourceControlSyncJobStreamByIdProperties)jsonReader.readObject(reader -> {
            SourceControlSyncJobStreamByIdProperties deserializedSourceControlSyncJobStreamByIdProperties = new SourceControlSyncJobStreamByIdProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceControlSyncJobStreamId".equals(fieldName)) {
                    deserializedSourceControlSyncJobStreamByIdProperties.sourceControlSyncJobStreamId = reader.getString();
                    continue;
                }
                if ("summary".equals(fieldName)) {
                    deserializedSourceControlSyncJobStreamByIdProperties.summary = reader.getString();
                    continue;
                }
                if ("time".equals(fieldName)) {
                    deserializedSourceControlSyncJobStreamByIdProperties.time = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("streamType".equals(fieldName)) {
                    deserializedSourceControlSyncJobStreamByIdProperties.streamType = StreamType.fromString(reader.getString());
                    continue;
                }
                if ("streamText".equals(fieldName)) {
                    deserializedSourceControlSyncJobStreamByIdProperties.streamText = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    Map value;
                    deserializedSourceControlSyncJobStreamByIdProperties.value = value = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceControlSyncJobStreamByIdProperties;
        });
    }
}

