/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.StreamType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SourceControlSyncJobStreamProperties
implements JsonSerializable<SourceControlSyncJobStreamProperties> {
    private String sourceControlSyncJobStreamId;
    private String summary;
    private OffsetDateTime time;
    private StreamType streamType;

    public String sourceControlSyncJobStreamId() {
        return this.sourceControlSyncJobStreamId;
    }

    public SourceControlSyncJobStreamProperties withSourceControlSyncJobStreamId(String sourceControlSyncJobStreamId) {
        this.sourceControlSyncJobStreamId = sourceControlSyncJobStreamId;
        return this;
    }

    public String summary() {
        return this.summary;
    }

    public SourceControlSyncJobStreamProperties withSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public OffsetDateTime time() {
        return this.time;
    }

    public StreamType streamType() {
        return this.streamType;
    }

    public SourceControlSyncJobStreamProperties withStreamType(StreamType streamType) {
        this.streamType = streamType;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceControlSyncJobStreamId", this.sourceControlSyncJobStreamId);
        jsonWriter.writeStringField("summary", this.summary);
        jsonWriter.writeStringField("streamType", this.streamType == null ? null : this.streamType.toString());
        return jsonWriter.writeEndObject();
    }

    public static SourceControlSyncJobStreamProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SourceControlSyncJobStreamProperties)jsonReader.readObject(reader -> {
            SourceControlSyncJobStreamProperties deserializedSourceControlSyncJobStreamProperties = new SourceControlSyncJobStreamProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceControlSyncJobStreamId".equals(fieldName)) {
                    deserializedSourceControlSyncJobStreamProperties.sourceControlSyncJobStreamId = reader.getString();
                    continue;
                }
                if ("summary".equals(fieldName)) {
                    deserializedSourceControlSyncJobStreamProperties.summary = reader.getString();
                    continue;
                }
                if ("time".equals(fieldName)) {
                    deserializedSourceControlSyncJobStreamProperties.time = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("streamType".equals(fieldName)) {
                    deserializedSourceControlSyncJobStreamProperties.streamType = StreamType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceControlSyncJobStreamProperties;
        });
    }
}

