/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.SourceControlSecurityTokenProperties;
import java.io.IOException;

public final class SourceControlUpdateProperties
implements JsonSerializable<SourceControlUpdateProperties> {
    private String branch;
    private String folderPath;
    private Boolean autoSync;
    private Boolean publishRunbook;
    private SourceControlSecurityTokenProperties securityToken;
    private String description;

    public String branch() {
        return this.branch;
    }

    public SourceControlUpdateProperties withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public String folderPath() {
        return this.folderPath;
    }

    public SourceControlUpdateProperties withFolderPath(String folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    public Boolean autoSync() {
        return this.autoSync;
    }

    public SourceControlUpdateProperties withAutoSync(Boolean autoSync) {
        this.autoSync = autoSync;
        return this;
    }

    public Boolean publishRunbook() {
        return this.publishRunbook;
    }

    public SourceControlUpdateProperties withPublishRunbook(Boolean publishRunbook) {
        this.publishRunbook = publishRunbook;
        return this;
    }

    public SourceControlSecurityTokenProperties securityToken() {
        return this.securityToken;
    }

    public SourceControlUpdateProperties withSecurityToken(SourceControlSecurityTokenProperties securityToken) {
        this.securityToken = securityToken;
        return this;
    }

    public String description() {
        return this.description;
    }

    public SourceControlUpdateProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.securityToken() != null) {
            this.securityToken().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("branch", this.branch);
        jsonWriter.writeStringField("folderPath", this.folderPath);
        jsonWriter.writeBooleanField("autoSync", this.autoSync);
        jsonWriter.writeBooleanField("publishRunbook", this.publishRunbook);
        jsonWriter.writeJsonField("securityToken", (JsonSerializable)this.securityToken);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static SourceControlUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SourceControlUpdateProperties)jsonReader.readObject(reader -> {
            SourceControlUpdateProperties deserializedSourceControlUpdateProperties = new SourceControlUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("branch".equals(fieldName)) {
                    deserializedSourceControlUpdateProperties.branch = reader.getString();
                    continue;
                }
                if ("folderPath".equals(fieldName)) {
                    deserializedSourceControlUpdateProperties.folderPath = reader.getString();
                    continue;
                }
                if ("autoSync".equals(fieldName)) {
                    deserializedSourceControlUpdateProperties.autoSync = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publishRunbook".equals(fieldName)) {
                    deserializedSourceControlUpdateProperties.publishRunbook = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("securityToken".equals(fieldName)) {
                    deserializedSourceControlUpdateProperties.securityToken = SourceControlSecurityTokenProperties.fromJson(reader);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSourceControlUpdateProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceControlUpdateProperties;
        });
    }
}

