/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class TestJobInner
implements JsonSerializable<TestJobInner> {
    private OffsetDateTime creationTime;
    private String status;
    private String statusDetails;
    private String runOn;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private String exception;
    private OffsetDateTime lastModifiedTime;
    private OffsetDateTime lastStatusModifiedTime;
    private Map<String, String> parameters;
    private Integer logActivityTrace;

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public TestJobInner withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public String status() {
        return this.status;
    }

    public TestJobInner withStatus(String status) {
        this.status = status;
        return this;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public TestJobInner withStatusDetails(String statusDetails) {
        this.statusDetails = statusDetails;
        return this;
    }

    public String runOn() {
        return this.runOn;
    }

    public TestJobInner withRunOn(String runOn) {
        this.runOn = runOn;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public TestJobInner withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public TestJobInner withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public String exception() {
        return this.exception;
    }

    public TestJobInner withException(String exception) {
        this.exception = exception;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public TestJobInner withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public OffsetDateTime lastStatusModifiedTime() {
        return this.lastStatusModifiedTime;
    }

    public TestJobInner withLastStatusModifiedTime(OffsetDateTime lastStatusModifiedTime) {
        this.lastStatusModifiedTime = lastStatusModifiedTime;
        return this;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public TestJobInner withParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Integer logActivityTrace() {
        return this.logActivityTrace;
    }

    public TestJobInner withLogActivityTrace(Integer logActivityTrace) {
        this.logActivityTrace = logActivityTrace;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("creationTime", this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("statusDetails", this.statusDetails);
        jsonWriter.writeStringField("runOn", this.runOn);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("exception", this.exception);
        jsonWriter.writeStringField("lastModifiedTime", this.lastModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        jsonWriter.writeStringField("lastStatusModifiedTime", this.lastStatusModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastStatusModifiedTime));
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("logActivityTrace", (Number)this.logActivityTrace);
        return jsonWriter.writeEndObject();
    }

    public static TestJobInner fromJson(JsonReader jsonReader) throws IOException {
        return (TestJobInner)jsonReader.readObject(reader -> {
            TestJobInner deserializedTestJobInner = new TestJobInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("creationTime".equals(fieldName)) {
                    deserializedTestJobInner.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedTestJobInner.status = reader.getString();
                    continue;
                }
                if ("statusDetails".equals(fieldName)) {
                    deserializedTestJobInner.statusDetails = reader.getString();
                    continue;
                }
                if ("runOn".equals(fieldName)) {
                    deserializedTestJobInner.runOn = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedTestJobInner.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedTestJobInner.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("exception".equals(fieldName)) {
                    deserializedTestJobInner.exception = reader.getString();
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedTestJobInner.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastStatusModifiedTime".equals(fieldName)) {
                    deserializedTestJobInner.lastStatusModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedTestJobInner.parameters = parameters = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("logActivityTrace".equals(fieldName)) {
                    deserializedTestJobInner.logActivityTrace = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTestJobInner;
        });
    }
}

