/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.JobNavigation;
import com.azure.resourcemanager.automation.models.UpdateConfigurationNavigation;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.UUID;

public final class UpdateConfigurationMachineRunProperties
implements JsonSerializable<UpdateConfigurationMachineRunProperties> {
    private String targetComputer;
    private String targetComputerType;
    private UpdateConfigurationNavigation softwareUpdateConfiguration;
    private String status;
    private String osType;
    private UUID correlationId;
    private UUID sourceComputerId;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private String configuredDuration;
    private JobNavigation job;
    private OffsetDateTime creationTime;
    private String createdBy;
    private OffsetDateTime lastModifiedTime;
    private String lastModifiedBy;
    private ManagementError error;

    public String targetComputer() {
        return this.targetComputer;
    }

    public String targetComputerType() {
        return this.targetComputerType;
    }

    public UpdateConfigurationNavigation softwareUpdateConfiguration() {
        return this.softwareUpdateConfiguration;
    }

    public UpdateConfigurationMachineRunProperties withSoftwareUpdateConfiguration(UpdateConfigurationNavigation softwareUpdateConfiguration) {
        this.softwareUpdateConfiguration = softwareUpdateConfiguration;
        return this;
    }

    public String status() {
        return this.status;
    }

    public String osType() {
        return this.osType;
    }

    public UUID correlationId() {
        return this.correlationId;
    }

    public UUID sourceComputerId() {
        return this.sourceComputerId;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public String configuredDuration() {
        return this.configuredDuration;
    }

    public JobNavigation job() {
        return this.job;
    }

    public UpdateConfigurationMachineRunProperties withJob(JobNavigation job) {
        this.job = job;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public String createdBy() {
        return this.createdBy;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public ManagementError error() {
        return this.error;
    }

    public UpdateConfigurationMachineRunProperties withError(ManagementError error) {
        this.error = error;
        return this;
    }

    public void validate() {
        if (this.softwareUpdateConfiguration() != null) {
            this.softwareUpdateConfiguration().validate();
        }
        if (this.job() != null) {
            this.job().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("softwareUpdateConfiguration", (JsonSerializable)this.softwareUpdateConfiguration);
        jsonWriter.writeJsonField("job", (JsonSerializable)this.job);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static UpdateConfigurationMachineRunProperties fromJson(JsonReader jsonReader) throws IOException {
        return (UpdateConfigurationMachineRunProperties)jsonReader.readObject(reader -> {
            UpdateConfigurationMachineRunProperties deserializedUpdateConfigurationMachineRunProperties = new UpdateConfigurationMachineRunProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetComputer".equals(fieldName)) {
                    deserializedUpdateConfigurationMachineRunProperties.targetComputer = reader.getString();
                    continue;
                }
                if ("targetComputerType".equals(fieldName)) {
                    deserializedUpdateConfigurationMachineRunProperties.targetComputerType = reader.getString();
                    continue;
                }
                if ("softwareUpdateConfiguration".equals(fieldName)) {
                    deserializedUpdateConfigurationMachineRunProperties.softwareUpdateConfiguration = UpdateConfigurationNavigation.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedUpdateConfigurationMachineRunProperties.status = reader.getString();
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    deserializedUpdateConfigurationMachineRunProperties.osType = reader.getString();
                    continue;
                }
                if ("correlationId".equals(fieldName)) {
                    deserializedUpdateConfigurationMachineRunProperties.correlationId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("sourceComputerId".equals(fieldName)) {
                    deserializedUpdateConfigurationMachineRunProperties.sourceComputerId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedUpdateConfigurationMachineRunProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedUpdateConfigurationMachineRunProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("configuredDuration".equals(fieldName)) {
                    deserializedUpdateConfigurationMachineRunProperties.configuredDuration = reader.getString();
                    continue;
                }
                if ("job".equals(fieldName)) {
                    deserializedUpdateConfigurationMachineRunProperties.job = JobNavigation.fromJson(reader);
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedUpdateConfigurationMachineRunProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedUpdateConfigurationMachineRunProperties.createdBy = reader.getString();
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedUpdateConfigurationMachineRunProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedUpdateConfigurationMachineRunProperties.lastModifiedBy = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedUpdateConfigurationMachineRunProperties.error = ManagementError.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUpdateConfigurationMachineRunProperties;
        });
    }
}

