/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.UsageCounterName;
import java.io.IOException;

public final class UsageInner
implements JsonSerializable<UsageInner> {
    private String id;
    private UsageCounterName name;
    private String unit;
    private Double currentValue;
    private Long limit;
    private String throttleStatus;

    public String id() {
        return this.id;
    }

    public UsageInner withId(String id) {
        this.id = id;
        return this;
    }

    public UsageCounterName name() {
        return this.name;
    }

    public UsageInner withName(UsageCounterName name) {
        this.name = name;
        return this;
    }

    public String unit() {
        return this.unit;
    }

    public UsageInner withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public Double currentValue() {
        return this.currentValue;
    }

    public UsageInner withCurrentValue(Double currentValue) {
        this.currentValue = currentValue;
        return this;
    }

    public Long limit() {
        return this.limit;
    }

    public UsageInner withLimit(Long limit) {
        this.limit = limit;
        return this;
    }

    public String throttleStatus() {
        return this.throttleStatus;
    }

    public UsageInner withThrottleStatus(String throttleStatus) {
        this.throttleStatus = throttleStatus;
        return this;
    }

    public void validate() {
        if (this.name() != null) {
            this.name().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("name", (JsonSerializable)this.name);
        jsonWriter.writeStringField("unit", this.unit);
        jsonWriter.writeNumberField("currentValue", (Number)this.currentValue);
        jsonWriter.writeNumberField("limit", (Number)this.limit);
        jsonWriter.writeStringField("throttleStatus", this.throttleStatus);
        return jsonWriter.writeEndObject();
    }

    public static UsageInner fromJson(JsonReader jsonReader) throws IOException {
        return (UsageInner)jsonReader.readObject(reader -> {
            UsageInner deserializedUsageInner = new UsageInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedUsageInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedUsageInner.name = UsageCounterName.fromJson(reader);
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedUsageInner.unit = reader.getString();
                    continue;
                }
                if ("currentValue".equals(fieldName)) {
                    deserializedUsageInner.currentValue = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("limit".equals(fieldName)) {
                    deserializedUsageInner.limit = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("throttleStatus".equals(fieldName)) {
                    deserializedUsageInner.throttleStatus = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUsageInner;
        });
    }
}

