/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class VariableProperties
implements JsonSerializable<VariableProperties> {
    private String value;
    private Boolean isEncrypted;
    private OffsetDateTime creationTime;
    private OffsetDateTime lastModifiedTime;
    private String description;

    public String value() {
        return this.value;
    }

    public VariableProperties withValue(String value) {
        this.value = value;
        return this;
    }

    public Boolean isEncrypted() {
        return this.isEncrypted;
    }

    public VariableProperties withIsEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public VariableProperties withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public VariableProperties withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public String description() {
        return this.description;
    }

    public VariableProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeBooleanField("isEncrypted", this.isEncrypted);
        jsonWriter.writeStringField("creationTime", this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        jsonWriter.writeStringField("lastModifiedTime", this.lastModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static VariableProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VariableProperties)jsonReader.readObject(reader -> {
            VariableProperties deserializedVariableProperties = new VariableProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedVariableProperties.value = reader.getString();
                    continue;
                }
                if ("isEncrypted".equals(fieldName)) {
                    deserializedVariableProperties.isEncrypted = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedVariableProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedVariableProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedVariableProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVariableProperties;
        });
    }
}

