/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.WatcherProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class WatcherInner
extends ProxyResource {
    private WatcherProperties innerProperties;
    private String etag;
    private Map<String, String> tags;
    private String location;
    private String type;
    private String name;
    private String id;

    private WatcherProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public WatcherInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public WatcherInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String location() {
        return this.location;
    }

    public WatcherInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public Long executionFrequencyInSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().executionFrequencyInSeconds();
    }

    public WatcherInner withExecutionFrequencyInSeconds(Long executionFrequencyInSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WatcherProperties();
        }
        this.innerProperties().withExecutionFrequencyInSeconds(executionFrequencyInSeconds);
        return this;
    }

    public String scriptName() {
        return this.innerProperties() == null ? null : this.innerProperties().scriptName();
    }

    public WatcherInner withScriptName(String scriptName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WatcherProperties();
        }
        this.innerProperties().withScriptName(scriptName);
        return this;
    }

    public Map<String, String> scriptParameters() {
        return this.innerProperties() == null ? null : this.innerProperties().scriptParameters();
    }

    public WatcherInner withScriptParameters(Map<String, String> scriptParameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WatcherProperties();
        }
        this.innerProperties().withScriptParameters(scriptParameters);
        return this;
    }

    public String scriptRunOn() {
        return this.innerProperties() == null ? null : this.innerProperties().scriptRunOn();
    }

    public WatcherInner withScriptRunOn(String scriptRunOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WatcherProperties();
        }
        this.innerProperties().withScriptRunOn(scriptRunOn);
        return this;
    }

    public String status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public String lastModifiedBy() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedBy();
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public WatcherInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WatcherProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("location", this.location);
        return jsonWriter.writeEndObject();
    }

    public static WatcherInner fromJson(JsonReader jsonReader) throws IOException {
        return (WatcherInner)((Object)jsonReader.readObject(reader -> {
            WatcherInner deserializedWatcherInner = new WatcherInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWatcherInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWatcherInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWatcherInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWatcherInner.innerProperties = WatcherProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedWatcherInner.etag = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedWatcherInner.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedWatcherInner.location = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWatcherInner;
        }));
    }
}

