/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class WatcherProperties
implements JsonSerializable<WatcherProperties> {
    private Long executionFrequencyInSeconds;
    private String scriptName;
    private Map<String, String> scriptParameters;
    private String scriptRunOn;
    private String status;
    private OffsetDateTime creationTime;
    private OffsetDateTime lastModifiedTime;
    private String lastModifiedBy;
    private String description;

    public Long executionFrequencyInSeconds() {
        return this.executionFrequencyInSeconds;
    }

    public WatcherProperties withExecutionFrequencyInSeconds(Long executionFrequencyInSeconds) {
        this.executionFrequencyInSeconds = executionFrequencyInSeconds;
        return this;
    }

    public String scriptName() {
        return this.scriptName;
    }

    public WatcherProperties withScriptName(String scriptName) {
        this.scriptName = scriptName;
        return this;
    }

    public Map<String, String> scriptParameters() {
        return this.scriptParameters;
    }

    public WatcherProperties withScriptParameters(Map<String, String> scriptParameters) {
        this.scriptParameters = scriptParameters;
        return this;
    }

    public String scriptRunOn() {
        return this.scriptRunOn;
    }

    public WatcherProperties withScriptRunOn(String scriptRunOn) {
        this.scriptRunOn = scriptRunOn;
        return this;
    }

    public String status() {
        return this.status;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public String description() {
        return this.description;
    }

    public WatcherProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("executionFrequencyInSeconds", (Number)this.executionFrequencyInSeconds);
        jsonWriter.writeStringField("scriptName", this.scriptName);
        jsonWriter.writeMapField("scriptParameters", this.scriptParameters, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("scriptRunOn", this.scriptRunOn);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static WatcherProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WatcherProperties)jsonReader.readObject(reader -> {
            WatcherProperties deserializedWatcherProperties = new WatcherProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("executionFrequencyInSeconds".equals(fieldName)) {
                    deserializedWatcherProperties.executionFrequencyInSeconds = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("scriptName".equals(fieldName)) {
                    deserializedWatcherProperties.scriptName = reader.getString();
                    continue;
                }
                if ("scriptParameters".equals(fieldName)) {
                    Map scriptParameters;
                    deserializedWatcherProperties.scriptParameters = scriptParameters = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("scriptRunOn".equals(fieldName)) {
                    deserializedWatcherProperties.scriptRunOn = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedWatcherProperties.status = reader.getString();
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedWatcherProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedWatcherProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedWatcherProperties.lastModifiedBy = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedWatcherProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWatcherProperties;
        });
    }
}

